import deimos.menu;
import std.conv : to;

const int CTRLD = 4;

immutable char[][] choices = [  "Choice 1",
                                "Choice 2",
                                "Choice 3",
                                "Choice 4",
                                "Choice 5",
                                "Choice 6",
                                "Choice 7",
                                "Exit"      ];

int main()
{
    ITEM*[] my_items;
    int c;
    MENU* my_menu;
    int n_choices, i;
    ITEM* cur_item;

    /* Initialize curses */
    initscr();
    start_color();
    cbreak();
    noecho();
    keypad(stdscr, true);
    init_pair(1, COLOR_RED, COLOR_BLACK);
    init_pair(2, COLOR_GREEN, COLOR_BLACK);
    init_pair(3, COLOR_MAGENTA, COLOR_BLACK);

    /* Initialize items */
    n_choices = choices.length.to!int;
    my_items.length = n_choices + 1;
    for (i = 0; i < n_choices; ++i)
        my_items[i] = new_item((choices[i] ~ '\0').ptr, (choices[i] ~ '\0').ptr);
    my_items[n_choices] = null;
    item_opts_off(my_items[3], O_SELECTABLE);
    item_opts_off(my_items[6], O_SELECTABLE);

    /* Create menu */
    my_menu = new_menu(my_items.ptr);

    /* Set fore ground and back ground of the menu */
    set_menu_fore(my_menu, COLOR_PAIR(1) | A_REVERSE);
    set_menu_back(my_menu, COLOR_PAIR(2));
    set_menu_grey(my_menu, COLOR_PAIR(3));

    /* Post the menu */
    mvprintw(LINES - 3, 0, "Press <ENTER> to see the option selected");
    mvprintw(LINES - 2, 0, "Up and Down arrow keys to naviage (F1 to Exit)");
    post_menu(my_menu);
    refresh();

    while ((c = getch()) != KEY_F(1))
    {
        switch (c)
        {
        case KEY_DOWN:
            menu_driver(my_menu, REQ_DOWN_ITEM);
            break;
        case KEY_UP:
            menu_driver(my_menu, REQ_UP_ITEM);
            break;
        case 10: /* Enter */
            move(20, 0);
            clrtoeol();
            mvprintw(20, 0, "Item selected is : %s", item_name(current_item(my_menu)));
            pos_menu_cursor(my_menu);
            break;
        default:
            break;
        }
    }
    unpost_menu(my_menu);
    for (i = 0; i < n_choices; ++i)
        free_item(my_items[i]);
    free_menu(my_menu);
    endwin();

    return 0;
}
