// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-none-eabi -target-feature +mve -mfloat-abi hard -O0 -disable-O0-optnone -S -emit-llvm -o - %s | opt -S -passes=mem2reg | FileCheck %s
// RUN: %clang_cc1 -DPOLYMORPHIC -triple thumbv8.1m.main-none-none-eabi -target-feature +mve -mfloat-abi hard -O0 -disable-O0-optnone -S -emit-llvm -o - %s | opt -S -passes=mem2reg | FileCheck %s

// REQUIRES: aarch64-registered-target || arm-registered-target

#include <arm_mve.h>

// CHECK-LABEL: @test_vqmovnbq_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vqmovn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vqmovnbq_s16(int8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqmovnbq(a, b);
#else /* POLYMORPHIC */
    return vqmovnbq_s16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovnbq_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vqmovn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vqmovnbq_s32(int16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqmovnbq(a, b);
#else /* POLYMORPHIC */
    return vqmovnbq_s32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovnbq_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vqmovn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqmovnbq_u16(uint8x16_t a, uint16x8_t b)
{
#ifdef POLYMORPHIC
    return vqmovnbq(a, b);
#else /* POLYMORPHIC */
    return vqmovnbq_u16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovnbq_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vqmovn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqmovnbq_u32(uint16x8_t a, uint32x4_t b)
{
#ifdef POLYMORPHIC
    return vqmovnbq(a, b);
#else /* POLYMORPHIC */
    return vqmovnbq_u32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovntq_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vqmovn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vqmovntq_s16(int8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqmovntq(a, b);
#else /* POLYMORPHIC */
    return vqmovntq_s16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovntq_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vqmovn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vqmovntq_s32(int16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqmovntq(a, b);
#else /* POLYMORPHIC */
    return vqmovntq_s32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovntq_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vqmovn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqmovntq_u16(uint8x16_t a, uint16x8_t b)
{
#ifdef POLYMORPHIC
    return vqmovntq(a, b);
#else /* POLYMORPHIC */
    return vqmovntq_u16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovntq_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vqmovn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqmovntq_u32(uint16x8_t a, uint32x4_t b)
{
#ifdef POLYMORPHIC
    return vqmovntq(a, b);
#else /* POLYMORPHIC */
    return vqmovntq_u32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovunbq_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vqmovn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 0, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqmovunbq_s16(uint8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqmovunbq(a, b);
#else /* POLYMORPHIC */
    return vqmovunbq_s16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovunbq_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vqmovn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 0, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqmovunbq_s32(uint16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqmovunbq(a, b);
#else /* POLYMORPHIC */
    return vqmovunbq_s32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovuntq_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vqmovn.v16i8.v8i16(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 0, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqmovuntq_s16(uint8x16_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqmovuntq(a, b);
#else /* POLYMORPHIC */
    return vqmovuntq_s16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovuntq_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vqmovn.v8i16.v4i32(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 0, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqmovuntq_s32(uint16x8_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqmovuntq(a, b);
#else /* POLYMORPHIC */
    return vqmovuntq_s32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovnbq_m_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vqmovn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 0, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vqmovnbq_m_s16(int8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqmovnbq_m(a, b, p);
#else /* POLYMORPHIC */
    return vqmovnbq_m_s16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovnbq_m_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vqmovn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 0, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vqmovnbq_m_s32(int16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqmovnbq_m(a, b, p);
#else /* POLYMORPHIC */
    return vqmovnbq_m_s32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovnbq_m_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vqmovn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 1, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqmovnbq_m_u16(uint8x16_t a, uint16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqmovnbq_m(a, b, p);
#else /* POLYMORPHIC */
    return vqmovnbq_m_u16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovnbq_m_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vqmovn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 1, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqmovnbq_m_u32(uint16x8_t a, uint32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqmovnbq_m(a, b, p);
#else /* POLYMORPHIC */
    return vqmovnbq_m_u32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovntq_m_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vqmovn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 0, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vqmovntq_m_s16(int8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqmovntq_m(a, b, p);
#else /* POLYMORPHIC */
    return vqmovntq_m_s16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovntq_m_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vqmovn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 0, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vqmovntq_m_s32(int16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqmovntq_m(a, b, p);
#else /* POLYMORPHIC */
    return vqmovntq_m_s32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovntq_m_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vqmovn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 1, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqmovntq_m_u16(uint8x16_t a, uint16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqmovntq_m(a, b, p);
#else /* POLYMORPHIC */
    return vqmovntq_m_u16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovntq_m_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vqmovn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 1, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqmovntq_m_u32(uint16x8_t a, uint32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqmovntq_m(a, b, p);
#else /* POLYMORPHIC */
    return vqmovntq_m_u32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovunbq_m_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vqmovn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 0, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqmovunbq_m_s16(uint8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqmovunbq_m(a, b, p);
#else /* POLYMORPHIC */
    return vqmovunbq_m_s16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovunbq_m_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vqmovn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 0, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqmovunbq_m_s32(uint16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqmovunbq_m(a, b, p);
#else /* POLYMORPHIC */
    return vqmovunbq_m_s32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovuntq_m_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vqmovn.predicated.v16i8.v8i16.v8i1(<16 x i8> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 0, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqmovuntq_m_s16(uint8x16_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqmovuntq_m(a, b, p);
#else /* POLYMORPHIC */
    return vqmovuntq_m_s16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqmovuntq_m_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vqmovn.predicated.v8i16.v4i32.v4i1(<8 x i16> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 0, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqmovuntq_m_s32(uint16x8_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqmovuntq_m(a, b, p);
#else /* POLYMORPHIC */
    return vqmovuntq_m_s32(a, b, p);
#endif /* POLYMORPHIC */
}

