/* Benchmarks for multibyte functions.
   Copyright (C) 2023 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

#include "striconv.h"

/* Quintus Horatius Flaccus
   Sermones
   Liber I, Sermo IX
 */
static char const text_latin_ascii[] =
  "ibam forte via sacra, sicut meus est mos,\n"
  "nescio quid meditans nugarum, totus in illis:\n"
  "accurrit quidam notus mihi nomine tantum\n"
  "arreptaque manu 'quid agis, dulcissime rerum?'\n"
  "'suaviter, ut nunc est,' inquam 'et cupio omnia quae vis.'\n"
  "cum adsectaretur, 'numquid vis?' occupo. at ille\n"
  "'noris nos' inquit; 'docti sumus.' hic ego 'pluris\n"
  "hoc' inquam 'mihi eris.' misere discedere quaerens\n"
  "ire modo ocius, interdum consistere, in aurem\n"
  "dicere nescio quid puero, cum sudor ad imos\n"
  "manaret talos. 'o te, Bolane, cerebri\n"
  "felicem' aiebam tacitus, cum quidlibet ille\n"
  "garriret, vicos, urbem laudaret. ut illi\n"
  "nil respondebam, 'misere cupis' inquit 'abire:\n"
  "iamdudum video; sed nil agis: usque tenebo;\n"
  "persequar hinc quo nunc iter est tibi.' 'nil opus est te\n"
  "circumagi: quendam volo visere non tibi notum;\n"
  "trans Tiberim longe cubat is prope Caesaris hortos.'\n"
  "'nil habeo quod agam et non sum piger: usque sequar te.'\n"
  "demitto auriculas, ut iniquae mentis asellus,\n"
  "cum gravius dorso subiit onus. incipit ille:\n"
  "'si bene me novi, non Viscum pluris amicum,\n"
  "non Varium facies; nam quis me scribere pluris\n"
  "aut citius possit versus? quis membra movere\n"
  "mollius? invideat quod et Hermogenes, ego canto.'\n"
  "interpellandi locus hic erat 'est tibi mater,\n"
  "cognati, quis te salvo est opus?' 'haud mihi quisquam.\n"
  "omnis conposui.' 'felices. nunc ego resto.\n"
  "confice; namque instat fatum mihi triste, Sabella\n"
  "quod puero cecinit divina mota anus urna:\n"
  "\"hunc neque dira venena nec hosticus auferet ensis\n"
  "nec laterum dolor aut tussis nec tarda podagra:\n"
  "garrulus hunc quando consumet cumque: loquaces,\n"
  "si sapiat, vitet, simul atque adoleverit aetas.\"'\n"
  "ventum erat ad Vestae, quarta iam parte diei\n"
  "praeterita, et casu tum respondere vadato\n"
  "debebat, quod ni fecisset, perdere litem.\n"
  "'si me amas,' inquit 'paulum hic ades.' 'inteream, si\n"
  "aut valeo stare aut novi civilia iura;\n"
  "et propero quo scis.' 'dubius sum, quid faciam', inquit,\n"
  "'tene relinquam an rem.' 'me, sodes.' 'non faciam' ille,\n"
  "et praecedere coepit; ego, ut contendere durum\n"
  "cum victore, sequor. 'Maecenas quomodo tecum?'\n"
  "hinc repetit. 'paucorum hominum et mentis bene sanae.'\n"
  "nemo dexterius fortuna est usus. haberes\n"
  "magnum adiutorem, posset qui ferre secundas,\n"
  "hunc hominem velles si tradere: dispeream, ni\n"
  "summosses omnis.' 'non isto vivimus illic,\n"
  "quo tu rere, modo; domus hac nec purior ulla est\n"
  "nec magis his aliena malis; nil mi officit, inquam,\n"
  "ditior hic aut est quia doctior; est locus uni\n"
  "cuique suus.' 'magnum narras, vix credibile.' 'atqui\n"
  "sic habet.' 'accendis quare cupiam magis illi\n"
  "proximus esse.' 'velis tantummodo: quae tua virtus,\n"
  "expugnabis: et est qui vinci possit eoque\n"
  "difficilis aditus primos habet.' 'haud mihi dero:\n"
  "muneribus servos corrumpam; non, hodie si\n"
  "exclusus fuero, desistam; tempora quaeram,\n"
  "occurram in triviis, deducam. nil sine magno\n"
  "vita labore dedit mortalibus.' haec dum agit, ecce\n"
  "Fuscus Aristius occurrit, mihi carus et illum\n"
  "qui pulchre nosset. consistimus. 'unde venis et\n"
  "quo tendis?' rogat et respondet. vellere coepi\n"
  "et pressare manu lentissima bracchia, nutans,\n"
  "distorquens oculos, ut me eriperet. male salsus\n"
  "ridens dissimulare; meum iecur urere bilis.\n"
  "'certe nescio quid secreto velle loqui te\n"
  "aiebas mecum.' 'memini bene, sed meliore\n"
  "tempore dicam; hodie tricensima sabbata: vin tu\n"
  "curtis Iudaeis oppedere?' 'nulla mihi' inquam\n"
  "'relligio est.' 'at mi: sum paulo infirmior, unus\n"
  "multorum. ignosces; alias loquar.' huncine solem\n"
  "tam nigrum surrexe mihi! fugit inprobus ac me\n"
  "sub cultro linquit. casu venit obvius illi\n"
  "adversarius et 'quo tu, turpissime?' magna\n"
  "inclamat voce, et 'licet antestari?' ego vero\n"
  "oppono auriculam. rapit in ius; clamor utrimque,\n"
  "undique concursus. sic me servavit Apollo.\n"
  ;

static char const text_french_utf8[] =
  "J'errais par hasard sur une voie sacrée, comme c'est ma coutume,\n"
  "Méditant je ne sais quoi de frivole, totalement absorbé par ces pensées :\n"
  "Arrive soudain quelqu'un de connu, seulement par son nom,\n"
  "Et me saisissant par la main, il dit : « Comment vas-tu, ô douceur des choses ? »\n"
  "« Agréablement, comme toujours, » dis-je, « et je désire tout ce que tu veux. »\n"
  "Alors qu'il me suivait, je l'interromps : « Veux-tu quelque chose ? » Mais lui,\n"
  "« Tu nous connais », dit-il, « nous sommes cultivés. » Ici, je réponds :\n"
  "« Tu me seras plus précieux à cause de cela. » Misérable, cherchant à partir,\n"
  "À aller maintenant plus vite, parfois à m'arrêter, à murmurer\n"
  "Je ne sais quoi à un garçon à l'oreille, tandis que la sueur descendait\n"
  "Jusqu'à mes chevilles. Silencieusement, je disais : « Ô toi, Bolanus, heureux d'esprit »,\n"
  "Tandis qu'il babillait sur tout et louait les rues et la ville.\n"
  "Comme je ne lui répondais rien, il dit : « Tu as envie de t'en aller misérablement :\n"
  "Je le vois depuis longtemps ; mais tu ne fais rien : je te retiendrai toujours ;\n"
  "Je te poursuivrai là où ton chemin mène maintenant. » « Il n'est pas nécessaire de tourner autour :\n"
  "Je veux rendre visite à quelqu'un qui ne te connaît pas ;\n"
  "Il repose loin au-delà du Tibre, près des jardins de César. »\n"
  "« Je n'ai rien à faire et je ne suis pas paresseux : je te suivrai toujours. »\n"
  "Je baisse les oreilles, comme un âne à l'esprit injuste,\n"
  "Lorsqu'un fardeau plus lourd s'abat sur son dos. Il commence :\n"
  "« Si je me connais bien, tu n'estimes pas plus Visque, mon ami,\n"
  "Ni Varron : car qui peut écrire des vers plus nombreux\n"
  "Et plus rapidement que moi ? Qui peut bouger\n"
  "Les membres plus gracieusement ? Qu'Hermogène l'envie,\n"
  "Je chante mieux que lui. » C'est ici que j'ai l'occasion de l'interrompre :\n"
  "« As-tu une mère, des parents, as-tu besoin de ton salut ? »\n"
  "« Je n'ai besoin de personne. J'ai tout arrangé. »\n"
  "« Heureux homme. Maintenant, je reste.\n"
  "Termine ; car un triste destin m'attend, que la vieille Sibylle\n"
  "A prophétisé pour moi, enfant, en secouant sa divine urne :\n"
  "\"Ni les venins maléfiques, ni l'épée ennemie\n"
  "Ni la douleur des côtes, ni la toux, ni la goutte lente :\n"
  "Ce bavard, chaque fois qu'il consomme, avec l'âge,\n"
  "Évite les bavards s'il a de la sagesse.\" »\n"
  "Nous étions arrivés devant le temple de Vesta, déjà le quart de la journée\n"
  "Passé, et par hasard, à ce moment-là, il devait répondre en caution,\n"
  "Car sinon il perdrait son procès. « Si tu m'aimes », dit-il, « reste ici un peu. »\n"
  "« Que je meure si je connais les lois civiles\n"
  "Ou si je peux me tenir debout ; et je me dépêche où tu le sais. »\n"
  "« Je suis indécis sur ce que je dois faire », dit-il,\n"
  "« Dois-je rester ou partir ? » « Reste, je t'en prie. » « Je ne le ferai pas », dit-il,\n"
  "Et il commença à marcher devant ; moi, comme un adversaire\n"
  "Acharné, je le suivis. « Comment ça va avec toi, Mécène ? »\n"
  "Il reprit à partir de là. « Pour quelques hommes et pour des esprits bien sains. »\n"
  "Personne n'a utilisé la fortune plus habilement. Tu avais\n"
  "Un grand soutien, quelqu'un qui pourrait t'apporter le succès,\n"
  "Si tu voulais livrer cet homme : Que je disparaisse si\n"
  "Tu ne l'avais pas écarté. « Nous ne vivons pas là-bas,\n"
  "Où tu le penses maintenant ; aucune maison n'est plus pure que celle-ci\n"
  "Et aucune n'est plus étrangère à ces maux ; rien ne me gêne, dis-je,\n"
  "Il est plus riche ou plus instruit ; chaque endroit a le sien. »\n"
  "« Tu racontes quelque chose de grand, à peine croyable. » « Et pourtant,\n"
  "C'est ainsi. » « Tu allumes en moi un désir plus grand d'être proche de lui. »\n"
  "« Tu le souhaites seulement : si ta vertu est ce qu'elle est,\n"
  "Tu le conquerras : et il est possible de le vaincre, et il a\n"
  "Une entrée difficile. » « Je ne m'abandonnerai pas :\n"
  "Je corromprai ses esclaves par des cadeaux ; non, même si\n"
  "Je suis exclu aujourd'hui, je n'abandonnerai pas ; je chercherai du temps,\n"
  "Je le rencontrerai aux carrefours, je le ramènerai. Rien n'est donné\n"
  "Aux mortels sans un grand labeur. » Alors qu'il parlait ainsi, voici\n"
  "Que Fuscus Aristius arrive, cher pour moi et qui connaissait aussi\n"
  "Très bien cet homme. Nous nous arrêtons. « D'où viens-tu et\n"
  "Où vas-tu ? » il demande et il répond. J'ai commencé à le tirer\n"
  "Et à presser sa main avec une lenteur extrême, en hochant la tête,\n"
  "En tournant les yeux, pour m'échapper de lui. Souriant malicieusement,\n"
  "Il dissimule mal ; il brûle mon foie de bile.\n"
  "« Certes, tu disais vouloir me dire quelque chose en secret,\n"
  "Toi avec moi. » « Je m'en souviens bien, mais je le dirai à une meilleure\n"
  "Occasion ; aujourd'hui, c'est le trentième sabbat : veux-tu\n"
  "T'opposer aux Juifs superstitieux ? » « Je n'ai aucune\n"
  "Religion. » « Moi, j'en ai un peu, je suis plus faible, l'un\n"
  "Parmi tant d'autres. Tu pardonneras ; je parlerai d'autre chose. »\n"
  "Ce soleil s'est-il levé si sombre pour moi ! Il s'enfuit méchamment et me\n"
  "Laisse sous le couteau. Par hasard, un adversaire vient à sa rencontre,\n"
  "Et lui crie à haute voix : « Où vas-tu, ô le plus vil des hommes ? »\n"
  "Et « Puis-je t'assigner devant un témoin ? » Et moi, bien sûr,\n"
  "Je lui tends l'oreille. Il l'entraîne devant le tribunal ; des cris de part et d'autre,\n"
  "Une foule se rassemble de tous côtés. Ainsi Apollon m'a sauvé.\n"
  ;

static char const *text_french_iso8859;

static char const text_greek_utf8[] =
  "περιπάτων μέντοι κατά την ιερή οδό, όπως είναι η συνήθειά μου,\n"
  "σκεφτόμενος άσχημα πράγματα, πλήρως αφοσιωμένος σε αυτά:\n"
  "έρχεται ένας γνωστός με όνομα μόνον,\n"
  "και αρπάζοντας το χέρι μου, λέει \"τι κάνεις, πιο γλυκέ των πραγμάτων;\"\n"
  "\"υπέροχα,\" απαντώ \"και θέλω ό,τι θέλεις εσύ.\"\n"
  "Όταν αυτός με ακολουθεί, λέω \"θέλεις κάτι;\" και τον προλαβαίνω. Αλλά αυτός\n"
  "λέει \"γνωρίζεις μας, είμαστε παιδεμένοι.\" Τότε εγώ λέω \"θα αξίζεις περισσότερα από αυτό.\"\n"
  "Επιζητώντας απεγνωσμένα να απομακρυνθεί,\n"
  "πηγαίνω ταχύτερα, μερικές φορές σταματώ, και προς το αυτί του αγοριού\n"
  "λέω κάτι, ενώ ο ιδρώτας κυλά στους αστραγάλους μου.\n"
  "\"Ω, Βόλανε, ευτυχισμένε τον νου σου\" λέω στον εαυτό μου σιωπηλά, ενώ αυτός\n"
  "λαλεί οτιδήποτε, επαινεί τους δρόμους, την πόλη. Επειδή δεν του απαντάω τίποτα,\n"
  "λέει \"θέλεις να φύγεις κακά; το βλέπω εδώ και καιρό, αλλά δεν κάνεις τίποτα· θα σε ακολουθήσω\n"
  "από 'δω που πας τώρα.\" \"Δεν χρειάζεται να περιστρέφεσαι: θέλω να δω κάποιον\n"
  "που δεν γνωρίζεις. Κοιμάται μακριά από τον Τίβερη, κοντά στους κήπους του Καίσαρα.\"\n"
  "\"Δεν έχω τίποτα άλλο να κάνω και δεν είμαι αργός: θα σε ακολουθήσω παντού.\"\n"
  "Αφήνω τα αυτιά μου, σαν ένας άτυχος γάιδαρος του νου,\n"
  "όταν φορτώνεται βαριά. Ξεκινάει λοιπόν:\n"
  "\"Αν με ξέρω καλά, δεν θεωρείς τον Βίσκο πιο φίλο,\n"
  "ούτε τον Βάριο· γιατί ποιος μπορεί να γράψει περισσότερα\n"
  "ή πιο γρήγορα ποιήματα; ποιος μπορεί να κινεί τα μέλη\n"
  "πιο απαλά; Ας ζηλεύει αυτόν ο Ερμογένης, εγώ τραγουδώ.\"\n"
  "Εδώ ήταν η ευκαιρία για διακοπή. \"Έχεις μητέρα,\n"
  "συγγενείς, χρειάζεσαι τη βοήθειά τους;\" \"Όχι, δεν χρειάζομαι κανέναν.\n"
  "Έχω οργανώσει τα πάντα.\" \"Είσαι ευτυχής. Εγώ τώρα\n"
  "μένω. Ολοκλήρωσε, γιατί με περιμένει ένα σκοτεινό πεπρωμένο,\n"
  "που προέβλεψε η ιερή γριά με τον κινούμενο αγγείο για το αγόρι:\n"
  "\"Ούτε φονικά φίλτρα ούτε εχθρικό σπαθί\n"
  "ούτε πόνος στο πλευρό ή βήχα ή βηματισμός ποδιού:\n"
  "αυτός ο λαλιάρης, κάποτε θα τον φάει τελείως: λοιπόν, αν είναι έξυπνος,\n"
  "ας τον αποφεύγει, όσο είναι νέος.\"\n"
  "Ήμασταν ήδη στην πλατεία της Βέστης, το τέταρτο μέρος της ημέρας\n"
  "είχε περάσει, και τυχαία έπρεπε να απαντήσει σε κάποιον δικαστή,\n"
  "αλλιώς θα έχανε τη δίκη. \"Αν με αγαπάς,\" λέει, \"μείνε εδώ λίγο.\" \"Να πεθάνω αν\n"
  "μπορώ να σταθώ ή αν γνωρίζω το πολιτικό δίκαιο·\n"
  "και βιάζομαι όπως ξέρεις.\" \"Διστάζω, τι να κάνω,\" λέει,\n"
  "\"να τον αφήσω ή να κρατήσω την υπόθεση.\" \"Εμένα, παρακαλώ.\" \"Δεν θα το κάνω,\" εκείνος λέει,\n"
  "και αρχίζει να προχωρά: εγώ, σαν να παλέυω με το δυσάρεστο\n"
  "νικητή, τον ακολουθώ. \"Μαικηνά, πώς είσαι με τον Μαίκηνα;\" ξαναρχίζει. \"Λέω εγώ.\n"
  "Για μερικούς ανθρώπους και τον νου τους που λειτουργεί καλά.\"\n"
  "Κανείς δεν είχε καλύτερη τύχη από τον Φορτούνατο. Αν είχες\n"
  "έναν μεγάλο βοηθό, που μπορούσε να σε φέρει σε ευνοϊκές θέσεις,\n"
  "θα τον ήθελες να σε παραδώσεις. Ας χαθώ, αν δεν\n"
  "απέκρουε όλους.\" \"Δεν ζούμε εκεί, όπου νομίζεις εσύ· αυτό το σπίτι\n"
  "δεν είναι πιο καθαρό από οποιοδήποτε άλλο,\n"
  "ούτε πιο ξένο σε κακά· δεν με ενοχλεί τίποτα, λέω,\n"
  "είτε είναι πιο πλούσιος ή είτε πιο μορφωμένος· κάθε ένας έχει τον δικό του τόπο.\"\n"
  "\"Μου λες κάτι μεγάλο, μόλις πιστεύω.\" \"Αλλά είναι έτσι.\"\n"
  "\"Ανάβεις την επιθυμία μου να είμαι πιο κοντά σε αυτόν.\" \"Απλά εύχεσαι: αν υπάρχει\n"
  "τέχνη στο να υποτάσσεται κανείς, θα τον κατακτήσεις: και υπάρχει κάποιος που μπορεί να ηττηθεί και γι' αυτό\n"
  "έχει δύσκολη πρόσβαση στην αρχή.\" \"Δεν θα το κάνω αυτό: θα διαφθείρω τους δούλους με δώρα· όχι, αν\n"
  "αποκλειστώ σήμερα, δεν θα εγκαταλείψω· θα βρω καιρό,\n"
  "θα του βρεθώ στις διασταυρώσεις, θα τον συνοδεύσω. Τίποτα δεν δίνεται στους θνητούς χωρίς μεγάλη προσπάθεια.\"\n"
  "Καθώς αυτό είπε, ιδού\n"
  "ο Φούσκος Αρίστιος έρχεται, φίλος μου και τον γνώριζε καλά. Σταθμεύουμε. \"Από πού έρχεσαι και\n"
  "πού πηγαίνεις;\" ρωτά και απαντώ. Άρχισα να τραβάω\n"
  "και να πιέζω τα πιο αργά μπράτσα με το χέρι, κουνώντας\n"
  "τα μάτια μου, για να με απελευθερώσει. Κακόγευστος,\n"
  "γελώντας προσπαθεί να το κρύψει· η χολή μου καίει το συκώτι.\n"
  "\"Σίγουρα είπες ότι θες να μιλήσεις μυστικά\n"
  "μαζί μου.\" \"Θυμάμαι καλά, αλλά θα σου το πω σε καλύτερη\n"
  "στιγμή· σήμερα είναι ο τριακοστός Σάββατος. Θες\n"
  "να πειράξεις τους Ιουδαίους στη συναγωγή;\" \"Για μένα δεν\n"
  "έχει καμία σημασία.\" \"Για μένα ναι: είμαι λίγο πιο αδύναμος, ένας\n"
  "από πολλούς. Θα με συγχωρέσεις· θα μιλήσω αλλού.\" Ο ήλιος\n"
  "αυτός, που ανατέλλει τόσο μαύρος για μένα! Αποδρά, με\n"
  "αφήνει με το μαχαίρι. Τυχαία συναντάει εκείνον τον αντίπαλο\n"
  "και φωνάζει με μεγάλη\n"
  "φωνή, \"Πού πηγαίνεις, εσύ, ελεεινός;\" και \"Μπορώ να μαρτυρήσω;\" Εγώ πραγματικά\n"
  "το αυτί. Τον παρασύρει στη δικαιοσύνη· φωνές από κάθε πλευρά,\n"
  "πλήθος που συρρέει. Έτσι με έσωσε ο Απόλλωνας.\n"
  ;

static char const *text_greek_iso8859;

static char const text_chinese_utf8[] =
  "我偶然走在圣路上，正如我的习惯，\n"
  "心里想着一些无聊的事情，全神贯注其中：\n"
  "突然有个熟人从我身边跑过，只知道我的名字，\n"
  "他一把抓住我的手说：“你好，最甜蜜的人！”\n"
  "我说：“很好，就像现在这样，我希望你愿意的一切。”\n"
  "他追问道：“你想做什么吗？”我匆忙回答。但他\n"
  "说：“你认识我们，我们很有学问。”我回答：“你在我眼中\n"
  "更有价值。”我想悲伤地告别，急着走得更快，有时候停下来，\n"
  "低声对一个小男孩说了一些话，汗水流到脚踝上。\n"
  "我默默地说：“哦，波拉斯，你的头脑是幸福的。”他尽情地\n"
  "胡扯，称赞街道，赞美城市。而我却\n"
  "没有回应他，他说：“你真想要离开，\n"
  "我早就知道了，但是你一直没有行动：我会一直陪着你，\n"
  "一直追随你的脚步。”我说：“没必要\n"
  "围绕我转，我想看望一个你不认识的人；\n"
  "他在蒂伯河对岸附近的凯撒花园附近。”\n"
  "“我无所事事，也不懒惰，我会一直跟着你。”\n"
  "我放低耳朵，就像一只不服管束的愚蠢的驴子，\n"
  "当背上的负担更沉重时。他开始说：\n"
  "“如果我了解自己，没有比维斯克斯更亲密的朋友，\n"
  "也没有比瓦里乌斯更有面子的人；因为谁能比我更快地\n"
  "写诗？谁能更优雅地运动肢体？连赫尔莫根尼斯都对此羡慕，\n"
  "我在唱歌。”在此刻插话：“你有母亲，\n"
  "亲戚，需要你吗？” “没有人需要我。\n"
  "我已经和他们都和解了。” “幸福啊，那我留下吧。\n"
  "写完吧，因为悲惨的命运正向我逼近，正如那个塞贝拉\n"
  "通过神圣的缸子预言给孩子的：\n"
  "‘他不会被致命的毒药、敌人的刀剑\n"
  "也不会被腰痛、咳嗽和痛风所杀；\n"
  "这个多话的家伙将一直说下去：假如有智慧，\n"
  "就该避免他，一旦年岁到了就远离他。’”\n"
  "我们到了维斯塔女神庙，已经过去了四分之一天，\n"
  "而他必须即时回应原告的请求，\n"
  "否则将败诉。他说：“如果你爱我，请在这里等一下。”\n"
  "“我会失去一切，如果我无法站立或了解公民的法律；\n"
  "而你知道我正匆匆赶去哪里。” “我很犹豫，不知道该做什么。”他说，\n"
  "“是留下还是走。” “拜托你，求求你。” “我不会这样做。”\n"
  "他开始走在前面，而我像一个与胜利者激烈竞争一样艰难地\n"
  "跟在他后面。 “梅塞纳斯，你和麦克纳斯怎样相处？”他又问了一次。\n"
  "他回答：“我们只和少数人以及头脑健全的人相处。”\n"
  "没有人比他更巧妙地运用运气。如果你有一个\n"
  "强大的帮手，可以承担起成功的重担，\n"
  "你一定会希望将他交给那个人：除非\n"
  "你把所有人都赶走。” “我们不是住在你\n"
  "认为的地方，最近的地方；这里没有比这个更纯净的房子，\n"
  "也没有比这个更遥远的灾难；我告诉你，我并不妨碍你，\n"
  "因为这里更富有也更有学问；每个人都有自己的位置。”\n"
  "“你说得很好，我几乎不能相信。” “然而，情况就是这样。”\n"
  "“你引起了我对他更加亲近的愿望。” “你只是愿意这样，你的才华，\n"
  "你会征服：而且有人可以战胜他，\n"
  "他的第一步是多么困难。” “我不会放弃的：\n"
  "我会用礼物收买奴仆；如果今天\n"
  "被排除在外，我不会放弃；我会寻找机会，\n"
  "在交叉路口遇到你，引领你。生活没有辛劳\n"
  "是不会给予凡人什么的。”当我在说这些话时，突然\n"
  "弗斯库斯·阿里斯提乌斯出现了，他对我和对他\n"
  "都很亲近。我们停下来。“你从哪里来，你要去哪里？”他问，\n"
  "并回答了他的问题。我试图拉他\n"
  "并用我迟缓的手臂拍打他，晃动着，\n"
  "歪曲着眼睛，希望他解救我。他狡猾地\n"
  "笑着假装不知道；我的胆汁烧灼着我的肝脏。\n"
  "“你显然想要和我私下交谈，”\n"
  "你说你会告诉我好的消息，但更好的时机\n"
  "我会在今天的星期三告诉你：你是不是\n"
  "在跟犹太人争论合法性？”我说：“对我来说没有\n"
  "宗教可言。” “但对我来说有：我稍微有些虚弱，是\n"
  "众多人中的一个。原谅我，我会说别的话。”\n"
  "“太阳为什么对我这样黑暗！这个卑鄙的人逃走了，\n"
  "并把我留在刀剑下。偶然地，一个敌人\n"
  "迎面走来，大声喊道：“你这个无耻之徒，你敢\n"
  "宣誓吗？”我当然伸出耳朵。他抓住我去上庭；\n"
  "双方都喊叫着，四处乱哄哄。阿波罗保护着我。\n"
  ;

static char const *text_chinese_gb18030;

static void
text_init ()
{
  text_french_iso8859 = str_iconv (text_french_utf8, "UTF-8", "ISO-8859-1");
  text_greek_iso8859 = str_iconv (text_greek_utf8, "UTF-8", "ISO-8859-7");
  text_chinese_gb18030 = str_iconv (text_chinese_utf8, "UTF-8", "GB18030");
}
