We're proud to announce the new feature release of darktable, 4.8.0!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-4.8.0](https://github.com/darktable-org/darktable/releases/tag/release-4.8.0).

As always, please don't use the autogenerated tarball provided by
github, but only our tar.xz file. The checksums are:

```
$ sha256sum darktable-4.8.0.tar.xz
??? darktable-4.8.0.tar.xz
$ sha256sum darktable-4.8.0-x86_64.dmg
??? darktable-4.8.0-x86_64.dmg
$ sha256sum darktable-4.8.0-arm64.dmg
??? darktable-4.8.0-arm64.dmg
$ sha256sum darktable-4.8.0-win64.exe
??? darktable-4.8.0.exe
```

When updating from the stable 4.6 series, please bear in
mind that your edits will be preserved during this process, but the new
library and configuration will no longer be usable with 4.6.

You are strongly advised to take a backup first.

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

Since darktable 4.6:

- 1484 commits to darktable+rawspeed
- 513 pull requests handled
- 60 issues closed


_Please note that the darktable documentation is not currently complete for release 4.8
and contributions are greatly appreciated. Please see the
[project documentation](https://github.com/darktable-org/dtdocs#contributing)
for more information on how to contribute._

## The Big Ones

The following is a summary of the main features added to darktable
4.8. Please see the user manual for more details of the individual
changes (where available).

- Introduced the color equalizer module to control
  hue/lightness/saturation based on colors.  This is a (partial)
  scene-referred replacement for the legacy color zones module.

- Two new modules have been introduced to support image composition.

  - Enlarge Canvas: As the name implies this module can be used to add
    areas on the left, right, top or bottom of the image. The new area
    can be assigned different color to help masking if necessary. The
    new areas can the be filled with the Retouch module by copying
    some other part of the image, using Liquify if the area is small
    or the new module overlay.

  - Overlay: This module can be used to add new content on the image
    by overlaying pixels from the current image or another image. The
    overlay content is defined by a drag-and-drop from the filmstrip
    to the Overlay module. This new content can be scaled, rotated and
    shifted horizontally or vertically. Using a mask it can be used to
    fill an area created by the Enlarge Canvas or to add some new part
    into the image using masking. A common example is to overlay
    multiply pictures of a firework to create a bigger one.

- Implemented a toggle switch for the darkroom mode forcing the
  pixel-pipe processing to use the whole image data instead of just the
  area displayed. This allows the user to inspect processed data
  without errors introduced via internal scaling and equals what we
  get by exporting in "high quality resampling" mode.

## Performance Improvements

- Rewrote the clustering code in map view for dramatically faster
  performance on large collections (mapping should now be usable with
  more than one million geotagged images selected).

## Other Changes

- Changed the sort order of tags to a natural and case insensitive order.

- Added Apple Keychain password storage backend for macOS devices.

- Collect module sorting has been integrated into the module's header
  instead of a preference. All collections can now be sorted easily by
  a single click on the sort button.

- Removed "unrestricted" mode from darktable's preferences resources
  for safety. This setting has been proved to be unsafe in many
  cases. It can still be enabled via the resource file if needed.

- Add buttons next to the snapshots to allow restoring it as the new
  history. Also the snapshots are now supporting drawn masks. It is
  possible to visualize the difference between the main darkroom view
  and a snapshot with different masking for example.

- Using <kbd>Right-Click</kbd> on color label icons (bottom toolbar of
  lighttable) it is possible to add a description to color
  labels. This is an handy way of remembering the color label usage in
  the workflow.

- Removed the AI options in color calibration module because of
  mediocre quality.

- It is now possible to import in-place pictures in a gvfs mount on
  GNU/Linux.

- Add a dashed outline of the current selected area in the print view.

- Added a few more EXIF fields to the image information module: White
  balance, exposure program, flash and metering mode.  These get
  filled automatically for new imports. For existing photos please
  perform a "refresh EXIF" on the selected images.

- Added Windows credential manager password storage backend.

- Added mask blending to the highlights reconstruction module.
  The generated raster mask holds the amount of reconstructed data and
  can be used with all algorithms.

- Color picker positions are defined by image coordinates instead of output.
  They will stay at the same location whatever distorting modules are used.

- The history autosaving might be disabled because of slow drives, this is
  now done per image instead globally.

- Added support for DNG files requiring the CameraCalibration tags for
  correct white balancing. (Some google pixel cameras for
  example). Requires re-reading exif metadata.

- Improved efficiency of the quick access panel by allowing modules to
  be reset and presets to be applied without opening the full module.
  Added more controls by default to further reduce the need to leave
  the panel while editing.

- Added more collection types and filters for flash, white balance,
  exposure program, metering mode and image grouping.

  Removed the old image grouping collection type and filter which gave
  confusing results.

- Added support for CMYK profiled histogram.

- The map view can now be scrolled with the arrow keys
  (left/right/up/down) in small steps and in combination with
  <kbd>Ctrl</kbd> in bigger steps.

## Bug Fixes

- Fix copy of multiple instances to ensure the proper order is applied
  when pasting to a new image.

- Fixing raw chromatic aberration on clang based systems.

- Fixes backthumb crawler for deleted history. We make sure that the
  crawler is aware of a deleted history and so will regenerate the
  thumbs as expected.

- Fix drawn masks visualizing in darkroom after pixelpipe module have
  changed. The drawn masks will now be properly adjusted if there is
  new distortion on the pipe for example. This was not the case until
  one was editing the mask.

- Fixed memleak while importing avif images.

- Fixed mask blending for sraw images while in IOP_CS_RAW colorspace.

- Fixed OpenCL device locking for modules calling dt_dev_pixelpipe_process().

- Fixed the UI becoming unresponsive due to very large history.

- Fixed UCS colorspace maths avoiding div-by-zero and out-of-gamut errors.

- Fixed a number of issues with guided filter blending and internal mask
  distortions.

- Fixed some issues related to cropping module and output/export
  dimensions.

- Fixed export processing when high quality is disabled and upscale is
  set.

- Fixed camera mounting when GPhoto2 internally reports a single
  attached camera multiple times.

- Fixed a issue preventing export to recent Piwigo's version.

- Fixes many stability issues for better overall robustness.

## Lua

### API Version

- API version is now 9.3.0

### Bug Fixes

### Add action support for Lua

### Other Lua changes

- Upgraded internal Lua to 5.4.6

- Added duplicate_image_with_history function to darktable.database

- button widget - added halign member to horizontally position the label

- button widget - added image member to use an image as the button label

- button widget - added image_align to horizontally position the image

- box widget - added expand member to control cells being expanded to fill the with of the box

- box widget - added fill member to control if the widgets fill the cell

- box widget - added padding member to control padding size of the cells

- added active_preset member to darktable.gui.libs to get the lib's active preset name

## Notes

- When exporting to AVIF, EXR, JPEG XL, or XCF, selecting specific
  metadata (e.g. geo-tag or creator) is not currently possible. For
  AVIF, EXR, JPEG XL, and XCF formats, darktable will not include any
  metadata fields unless the user selects all of the checkboxes in the
  export module's preference options.

- In order to support the correct display of numbers in darktable, the
  minimum supported Gtk version has had to be increased to
  3.24.15. For people who need to build darktable with an older
  version, this can be achieved by removing line 241 of the
  `darktable.css` file on your system. See
  https://github.com/darktable-org/darktable/issues/13166.

- Starting with release 4.4 a new support policy regarding macOS
  versions has been put in place – darktable releases will now only
  support those macOS versions that are also supported by Apple.
  Release 4.6 therefore drops support for macOS versions older than
  12.5.

## Changed Dependencies

### Mandatory

- Minimum libpng version 1.5.x is now required
- Bump Exiv2 requirement to 0.27.2
- Minimum pugixml version 1.5 is now required
- Minimum libcurl version 7.56 is now required

### Optional

- n/a

## RawSpeed changes

- Fujifilm X-Trans 4 based and newer cameras now use the vendor supplied crop

## Camera support, compared to 4.6

### Base Support

- Canon EOS R100 (requires LibRaw 202403 and later)
- Canon EOS R50 (requires LibRaw 202403 and later)
- Canon EOS R6 Mark II (requires LibRaw 202403 and later)
- Canon EOS R8 (requires LibRaw 202403 and later)
- Canon EOS Ra (requires LibRaw 202403 and later)
- Fujifilm FinePix S9600fd
- Fujifilm X100VI (compressed)
- GoPro FUSION (DNG)
- Leica SL3 (DNG)
- OM System OM-1 Mark II
- Panasonic DC-TZ95D (4:3)
- Panasonic DMC-FX150 (4:3, 3:2, 16:9)
- Panasonic DMC-FZ28 (3:2)
- Phase One P25+
- Phase One P45+
- Ricoh GR III HDF (DNG)
- Ricoh GR IIIx HDF (DNG)
- Sony ILCE-9M3
- Sony UMC-R10C

### White Balance Presets

- Canon EOS R6 Mark II (requires LibRaw 202403 and later)
- Fujifilm X-H2
- OM System OM-1 Mark II
- OM System OM-5

### Noise Profiles

- Canon EOS R6 Mark II (requires LibRaw 202403 and later)
- Fujifilm GFX 50R
- OM System OM-1 Mark II
- OM System OM-5
- Phase One IQ180
- Sony ILCE-9M3
- Sony ZV-1

### Missing Compression Mode Support

- Apple ProRAW DNGs
- CinemaDNG lossless (Blackmagic, some DJI, etc.) and lossy (Blackmagic)
- DNG 1.7 using JPEG XL (Adobe enhanced, Samsung Expert RAW)
- Fujifilm lossy RAFs
- Nikon high efficiency NEFs
- OM System 14-bit high resolution ORFs
- Sony downsized lossless ARWs ("M" for full-frame, "S" for full-frame & APS-C)

### Suspended Support

Support for the following cameras is suspended because no samples are available on https://raw.pixls.us:

- Creo/Leaf Aptus 22(LF3779)/Hasselblad H1
- Fujifilm IS-1
- Kodak EasyShare Z980
- Leaf Aptus-II 5(LI300059)/Mamiya 645 AFD
- Leaf Credo 60
- Leaf Credo 80
- Minolta DiMAGE 5
- Olympus SP320
- Phase One IQ250
- Sinar Hy6/ Sinarback eXact
- ST Micro STV680

## Translations

## Translations

- Czech
- German
- European Spanish
- Finnish
- French
- Hungarian
- Italian
- Japanese
- Dutch
- Polish
- Brazilian Portuguese
- Russian
- Slovenian
- Albanian
- Ukrainian
- Chinese (Simplified)
- Chinese (Traditional)
