/*
* Comba Multiplication and Squaring
*
* This file was automatically generated by ./src/scripts/dev_tools/gen_mp_comba.py on 2023-05-29
*
* Botan is released under the Simplified BSD License (see license.txt)
*/

#include <botan/internal/mp_core.h>

namespace Botan {

/*
* Comba 4x4 Squaring
*/
void bigint_comba_sqr4(word z[8], const word x[4]) {
   word w2 = 0, w1 = 0, w0 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], x[0]);
   z[0] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[1]);
   z[1] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[2]);
   word3_muladd(&w1, &w0, &w2, x[1], x[1]);
   z[2] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[3]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[2]);
   z[3] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[1], x[3]);
   word3_muladd(&w0, &w2, &w1, x[2], x[2]);
   z[4] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[2], x[3]);
   z[5] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[3], x[3]);
   z[6] = w0;
   z[7] = w1;
}

/*
* Comba 4x4 Multiplication
*/
void bigint_comba_mul4(word z[8], const word x[4], const word y[4]) {
   word w2 = 0, w1 = 0, w0 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[0]);
   z[0] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[1]);
   word3_muladd(&w0, &w2, &w1, x[1], y[0]);
   z[1] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[2]);
   word3_muladd(&w1, &w0, &w2, x[1], y[1]);
   word3_muladd(&w1, &w0, &w2, x[2], y[0]);
   z[2] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[3]);
   word3_muladd(&w2, &w1, &w0, x[1], y[2]);
   word3_muladd(&w2, &w1, &w0, x[2], y[1]);
   word3_muladd(&w2, &w1, &w0, x[3], y[0]);
   z[3] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[1], y[3]);
   word3_muladd(&w0, &w2, &w1, x[2], y[2]);
   word3_muladd(&w0, &w2, &w1, x[3], y[1]);
   z[4] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[2], y[3]);
   word3_muladd(&w1, &w0, &w2, x[3], y[2]);
   z[5] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[3], y[3]);
   z[6] = w0;
   z[7] = w1;
}

/*
* Comba 6x6 Squaring
*/
void bigint_comba_sqr6(word z[12], const word x[6]) {
   word w2 = 0, w1 = 0, w0 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], x[0]);
   z[0] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[1]);
   z[1] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[2]);
   word3_muladd(&w1, &w0, &w2, x[1], x[1]);
   z[2] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[3]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[2]);
   z[3] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[4]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[3]);
   word3_muladd(&w0, &w2, &w1, x[2], x[2]);
   z[4] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[5]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[4]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[3]);
   z[5] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[1], x[5]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[4]);
   word3_muladd(&w2, &w1, &w0, x[3], x[3]);
   z[6] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[2], x[5]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[4]);
   z[7] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[3], x[5]);
   word3_muladd(&w1, &w0, &w2, x[4], x[4]);
   z[8] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[4], x[5]);
   z[9] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[5], x[5]);
   z[10] = w1;
   z[11] = w2;
}

/*
* Comba 6x6 Multiplication
*/
void bigint_comba_mul6(word z[12], const word x[6], const word y[6]) {
   word w2 = 0, w1 = 0, w0 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[0]);
   z[0] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[1]);
   word3_muladd(&w0, &w2, &w1, x[1], y[0]);
   z[1] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[2]);
   word3_muladd(&w1, &w0, &w2, x[1], y[1]);
   word3_muladd(&w1, &w0, &w2, x[2], y[0]);
   z[2] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[3]);
   word3_muladd(&w2, &w1, &w0, x[1], y[2]);
   word3_muladd(&w2, &w1, &w0, x[2], y[1]);
   word3_muladd(&w2, &w1, &w0, x[3], y[0]);
   z[3] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[4]);
   word3_muladd(&w0, &w2, &w1, x[1], y[3]);
   word3_muladd(&w0, &w2, &w1, x[2], y[2]);
   word3_muladd(&w0, &w2, &w1, x[3], y[1]);
   word3_muladd(&w0, &w2, &w1, x[4], y[0]);
   z[4] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[5]);
   word3_muladd(&w1, &w0, &w2, x[1], y[4]);
   word3_muladd(&w1, &w0, &w2, x[2], y[3]);
   word3_muladd(&w1, &w0, &w2, x[3], y[2]);
   word3_muladd(&w1, &w0, &w2, x[4], y[1]);
   word3_muladd(&w1, &w0, &w2, x[5], y[0]);
   z[5] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[1], y[5]);
   word3_muladd(&w2, &w1, &w0, x[2], y[4]);
   word3_muladd(&w2, &w1, &w0, x[3], y[3]);
   word3_muladd(&w2, &w1, &w0, x[4], y[2]);
   word3_muladd(&w2, &w1, &w0, x[5], y[1]);
   z[6] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[2], y[5]);
   word3_muladd(&w0, &w2, &w1, x[3], y[4]);
   word3_muladd(&w0, &w2, &w1, x[4], y[3]);
   word3_muladd(&w0, &w2, &w1, x[5], y[2]);
   z[7] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[3], y[5]);
   word3_muladd(&w1, &w0, &w2, x[4], y[4]);
   word3_muladd(&w1, &w0, &w2, x[5], y[3]);
   z[8] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[4], y[5]);
   word3_muladd(&w2, &w1, &w0, x[5], y[4]);
   z[9] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[5], y[5]);
   z[10] = w1;
   z[11] = w2;
}

/*
* Comba 8x8 Squaring
*/
void bigint_comba_sqr8(word z[16], const word x[8]) {
   word w2 = 0, w1 = 0, w0 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], x[0]);
   z[0] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[1]);
   z[1] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[2]);
   word3_muladd(&w1, &w0, &w2, x[1], x[1]);
   z[2] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[3]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[2]);
   z[3] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[4]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[3]);
   word3_muladd(&w0, &w2, &w1, x[2], x[2]);
   z[4] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[5]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[4]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[3]);
   z[5] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[6]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[5]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[4]);
   word3_muladd(&w2, &w1, &w0, x[3], x[3]);
   z[6] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[7]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[6]);
   word3_muladd_2(&w0, &w2, &w1, x[2], x[5]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[4]);
   z[7] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[1], x[7]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[6]);
   word3_muladd_2(&w1, &w0, &w2, x[3], x[5]);
   word3_muladd(&w1, &w0, &w2, x[4], x[4]);
   z[8] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[2], x[7]);
   word3_muladd_2(&w2, &w1, &w0, x[3], x[6]);
   word3_muladd_2(&w2, &w1, &w0, x[4], x[5]);
   z[9] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[3], x[7]);
   word3_muladd_2(&w0, &w2, &w1, x[4], x[6]);
   word3_muladd(&w0, &w2, &w1, x[5], x[5]);
   z[10] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[4], x[7]);
   word3_muladd_2(&w1, &w0, &w2, x[5], x[6]);
   z[11] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[5], x[7]);
   word3_muladd(&w2, &w1, &w0, x[6], x[6]);
   z[12] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[6], x[7]);
   z[13] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[7], x[7]);
   z[14] = w2;
   z[15] = w0;
}

/*
* Comba 8x8 Multiplication
*/
void bigint_comba_mul8(word z[16], const word x[8], const word y[8]) {
   word w2 = 0, w1 = 0, w0 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[0]);
   z[0] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[1]);
   word3_muladd(&w0, &w2, &w1, x[1], y[0]);
   z[1] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[2]);
   word3_muladd(&w1, &w0, &w2, x[1], y[1]);
   word3_muladd(&w1, &w0, &w2, x[2], y[0]);
   z[2] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[3]);
   word3_muladd(&w2, &w1, &w0, x[1], y[2]);
   word3_muladd(&w2, &w1, &w0, x[2], y[1]);
   word3_muladd(&w2, &w1, &w0, x[3], y[0]);
   z[3] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[4]);
   word3_muladd(&w0, &w2, &w1, x[1], y[3]);
   word3_muladd(&w0, &w2, &w1, x[2], y[2]);
   word3_muladd(&w0, &w2, &w1, x[3], y[1]);
   word3_muladd(&w0, &w2, &w1, x[4], y[0]);
   z[4] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[5]);
   word3_muladd(&w1, &w0, &w2, x[1], y[4]);
   word3_muladd(&w1, &w0, &w2, x[2], y[3]);
   word3_muladd(&w1, &w0, &w2, x[3], y[2]);
   word3_muladd(&w1, &w0, &w2, x[4], y[1]);
   word3_muladd(&w1, &w0, &w2, x[5], y[0]);
   z[5] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[6]);
   word3_muladd(&w2, &w1, &w0, x[1], y[5]);
   word3_muladd(&w2, &w1, &w0, x[2], y[4]);
   word3_muladd(&w2, &w1, &w0, x[3], y[3]);
   word3_muladd(&w2, &w1, &w0, x[4], y[2]);
   word3_muladd(&w2, &w1, &w0, x[5], y[1]);
   word3_muladd(&w2, &w1, &w0, x[6], y[0]);
   z[6] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[7]);
   word3_muladd(&w0, &w2, &w1, x[1], y[6]);
   word3_muladd(&w0, &w2, &w1, x[2], y[5]);
   word3_muladd(&w0, &w2, &w1, x[3], y[4]);
   word3_muladd(&w0, &w2, &w1, x[4], y[3]);
   word3_muladd(&w0, &w2, &w1, x[5], y[2]);
   word3_muladd(&w0, &w2, &w1, x[6], y[1]);
   word3_muladd(&w0, &w2, &w1, x[7], y[0]);
   z[7] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[1], y[7]);
   word3_muladd(&w1, &w0, &w2, x[2], y[6]);
   word3_muladd(&w1, &w0, &w2, x[3], y[5]);
   word3_muladd(&w1, &w0, &w2, x[4], y[4]);
   word3_muladd(&w1, &w0, &w2, x[5], y[3]);
   word3_muladd(&w1, &w0, &w2, x[6], y[2]);
   word3_muladd(&w1, &w0, &w2, x[7], y[1]);
   z[8] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[2], y[7]);
   word3_muladd(&w2, &w1, &w0, x[3], y[6]);
   word3_muladd(&w2, &w1, &w0, x[4], y[5]);
   word3_muladd(&w2, &w1, &w0, x[5], y[4]);
   word3_muladd(&w2, &w1, &w0, x[6], y[3]);
   word3_muladd(&w2, &w1, &w0, x[7], y[2]);
   z[9] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[3], y[7]);
   word3_muladd(&w0, &w2, &w1, x[4], y[6]);
   word3_muladd(&w0, &w2, &w1, x[5], y[5]);
   word3_muladd(&w0, &w2, &w1, x[6], y[4]);
   word3_muladd(&w0, &w2, &w1, x[7], y[3]);
   z[10] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[4], y[7]);
   word3_muladd(&w1, &w0, &w2, x[5], y[6]);
   word3_muladd(&w1, &w0, &w2, x[6], y[5]);
   word3_muladd(&w1, &w0, &w2, x[7], y[4]);
   z[11] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[5], y[7]);
   word3_muladd(&w2, &w1, &w0, x[6], y[6]);
   word3_muladd(&w2, &w1, &w0, x[7], y[5]);
   z[12] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[6], y[7]);
   word3_muladd(&w0, &w2, &w1, x[7], y[6]);
   z[13] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[7], y[7]);
   z[14] = w2;
   z[15] = w0;
}

/*
* Comba 9x9 Squaring
*/
void bigint_comba_sqr9(word z[18], const word x[9]) {
   word w2 = 0, w1 = 0, w0 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], x[0]);
   z[0] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[1]);
   z[1] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[2]);
   word3_muladd(&w1, &w0, &w2, x[1], x[1]);
   z[2] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[3]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[2]);
   z[3] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[4]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[3]);
   word3_muladd(&w0, &w2, &w1, x[2], x[2]);
   z[4] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[5]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[4]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[3]);
   z[5] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[6]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[5]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[4]);
   word3_muladd(&w2, &w1, &w0, x[3], x[3]);
   z[6] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[7]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[6]);
   word3_muladd_2(&w0, &w2, &w1, x[2], x[5]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[4]);
   z[7] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[8]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[7]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[6]);
   word3_muladd_2(&w1, &w0, &w2, x[3], x[5]);
   word3_muladd(&w1, &w0, &w2, x[4], x[4]);
   z[8] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[1], x[8]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[7]);
   word3_muladd_2(&w2, &w1, &w0, x[3], x[6]);
   word3_muladd_2(&w2, &w1, &w0, x[4], x[5]);
   z[9] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[2], x[8]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[7]);
   word3_muladd_2(&w0, &w2, &w1, x[4], x[6]);
   word3_muladd(&w0, &w2, &w1, x[5], x[5]);
   z[10] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[3], x[8]);
   word3_muladd_2(&w1, &w0, &w2, x[4], x[7]);
   word3_muladd_2(&w1, &w0, &w2, x[5], x[6]);
   z[11] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[4], x[8]);
   word3_muladd_2(&w2, &w1, &w0, x[5], x[7]);
   word3_muladd(&w2, &w1, &w0, x[6], x[6]);
   z[12] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[5], x[8]);
   word3_muladd_2(&w0, &w2, &w1, x[6], x[7]);
   z[13] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[6], x[8]);
   word3_muladd(&w1, &w0, &w2, x[7], x[7]);
   z[14] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[7], x[8]);
   z[15] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[8], x[8]);
   z[16] = w1;
   z[17] = w2;
}

/*
* Comba 9x9 Multiplication
*/
void bigint_comba_mul9(word z[18], const word x[9], const word y[9]) {
   word w2 = 0, w1 = 0, w0 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[0]);
   z[0] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[1]);
   word3_muladd(&w0, &w2, &w1, x[1], y[0]);
   z[1] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[2]);
   word3_muladd(&w1, &w0, &w2, x[1], y[1]);
   word3_muladd(&w1, &w0, &w2, x[2], y[0]);
   z[2] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[3]);
   word3_muladd(&w2, &w1, &w0, x[1], y[2]);
   word3_muladd(&w2, &w1, &w0, x[2], y[1]);
   word3_muladd(&w2, &w1, &w0, x[3], y[0]);
   z[3] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[4]);
   word3_muladd(&w0, &w2, &w1, x[1], y[3]);
   word3_muladd(&w0, &w2, &w1, x[2], y[2]);
   word3_muladd(&w0, &w2, &w1, x[3], y[1]);
   word3_muladd(&w0, &w2, &w1, x[4], y[0]);
   z[4] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[5]);
   word3_muladd(&w1, &w0, &w2, x[1], y[4]);
   word3_muladd(&w1, &w0, &w2, x[2], y[3]);
   word3_muladd(&w1, &w0, &w2, x[3], y[2]);
   word3_muladd(&w1, &w0, &w2, x[4], y[1]);
   word3_muladd(&w1, &w0, &w2, x[5], y[0]);
   z[5] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[6]);
   word3_muladd(&w2, &w1, &w0, x[1], y[5]);
   word3_muladd(&w2, &w1, &w0, x[2], y[4]);
   word3_muladd(&w2, &w1, &w0, x[3], y[3]);
   word3_muladd(&w2, &w1, &w0, x[4], y[2]);
   word3_muladd(&w2, &w1, &w0, x[5], y[1]);
   word3_muladd(&w2, &w1, &w0, x[6], y[0]);
   z[6] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[7]);
   word3_muladd(&w0, &w2, &w1, x[1], y[6]);
   word3_muladd(&w0, &w2, &w1, x[2], y[5]);
   word3_muladd(&w0, &w2, &w1, x[3], y[4]);
   word3_muladd(&w0, &w2, &w1, x[4], y[3]);
   word3_muladd(&w0, &w2, &w1, x[5], y[2]);
   word3_muladd(&w0, &w2, &w1, x[6], y[1]);
   word3_muladd(&w0, &w2, &w1, x[7], y[0]);
   z[7] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[8]);
   word3_muladd(&w1, &w0, &w2, x[1], y[7]);
   word3_muladd(&w1, &w0, &w2, x[2], y[6]);
   word3_muladd(&w1, &w0, &w2, x[3], y[5]);
   word3_muladd(&w1, &w0, &w2, x[4], y[4]);
   word3_muladd(&w1, &w0, &w2, x[5], y[3]);
   word3_muladd(&w1, &w0, &w2, x[6], y[2]);
   word3_muladd(&w1, &w0, &w2, x[7], y[1]);
   word3_muladd(&w1, &w0, &w2, x[8], y[0]);
   z[8] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[1], y[8]);
   word3_muladd(&w2, &w1, &w0, x[2], y[7]);
   word3_muladd(&w2, &w1, &w0, x[3], y[6]);
   word3_muladd(&w2, &w1, &w0, x[4], y[5]);
   word3_muladd(&w2, &w1, &w0, x[5], y[4]);
   word3_muladd(&w2, &w1, &w0, x[6], y[3]);
   word3_muladd(&w2, &w1, &w0, x[7], y[2]);
   word3_muladd(&w2, &w1, &w0, x[8], y[1]);
   z[9] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[2], y[8]);
   word3_muladd(&w0, &w2, &w1, x[3], y[7]);
   word3_muladd(&w0, &w2, &w1, x[4], y[6]);
   word3_muladd(&w0, &w2, &w1, x[5], y[5]);
   word3_muladd(&w0, &w2, &w1, x[6], y[4]);
   word3_muladd(&w0, &w2, &w1, x[7], y[3]);
   word3_muladd(&w0, &w2, &w1, x[8], y[2]);
   z[10] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[3], y[8]);
   word3_muladd(&w1, &w0, &w2, x[4], y[7]);
   word3_muladd(&w1, &w0, &w2, x[5], y[6]);
   word3_muladd(&w1, &w0, &w2, x[6], y[5]);
   word3_muladd(&w1, &w0, &w2, x[7], y[4]);
   word3_muladd(&w1, &w0, &w2, x[8], y[3]);
   z[11] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[4], y[8]);
   word3_muladd(&w2, &w1, &w0, x[5], y[7]);
   word3_muladd(&w2, &w1, &w0, x[6], y[6]);
   word3_muladd(&w2, &w1, &w0, x[7], y[5]);
   word3_muladd(&w2, &w1, &w0, x[8], y[4]);
   z[12] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[5], y[8]);
   word3_muladd(&w0, &w2, &w1, x[6], y[7]);
   word3_muladd(&w0, &w2, &w1, x[7], y[6]);
   word3_muladd(&w0, &w2, &w1, x[8], y[5]);
   z[13] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[6], y[8]);
   word3_muladd(&w1, &w0, &w2, x[7], y[7]);
   word3_muladd(&w1, &w0, &w2, x[8], y[6]);
   z[14] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[7], y[8]);
   word3_muladd(&w2, &w1, &w0, x[8], y[7]);
   z[15] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[8], y[8]);
   z[16] = w1;
   z[17] = w2;
}

/*
* Comba 16x16 Squaring
*/
void bigint_comba_sqr16(word z[32], const word x[16]) {
   word w2 = 0, w1 = 0, w0 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], x[0]);
   z[0] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[1]);
   z[1] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[2]);
   word3_muladd(&w1, &w0, &w2, x[1], x[1]);
   z[2] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[3]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[2]);
   z[3] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[4]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[3]);
   word3_muladd(&w0, &w2, &w1, x[2], x[2]);
   z[4] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[5]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[4]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[3]);
   z[5] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[6]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[5]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[4]);
   word3_muladd(&w2, &w1, &w0, x[3], x[3]);
   z[6] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[7]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[6]);
   word3_muladd_2(&w0, &w2, &w1, x[2], x[5]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[4]);
   z[7] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[8]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[7]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[6]);
   word3_muladd_2(&w1, &w0, &w2, x[3], x[5]);
   word3_muladd(&w1, &w0, &w2, x[4], x[4]);
   z[8] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[9]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[8]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[7]);
   word3_muladd_2(&w2, &w1, &w0, x[3], x[6]);
   word3_muladd_2(&w2, &w1, &w0, x[4], x[5]);
   z[9] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[10]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[9]);
   word3_muladd_2(&w0, &w2, &w1, x[2], x[8]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[7]);
   word3_muladd_2(&w0, &w2, &w1, x[4], x[6]);
   word3_muladd(&w0, &w2, &w1, x[5], x[5]);
   z[10] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[11]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[10]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[9]);
   word3_muladd_2(&w1, &w0, &w2, x[3], x[8]);
   word3_muladd_2(&w1, &w0, &w2, x[4], x[7]);
   word3_muladd_2(&w1, &w0, &w2, x[5], x[6]);
   z[11] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[12]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[11]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[10]);
   word3_muladd_2(&w2, &w1, &w0, x[3], x[9]);
   word3_muladd_2(&w2, &w1, &w0, x[4], x[8]);
   word3_muladd_2(&w2, &w1, &w0, x[5], x[7]);
   word3_muladd(&w2, &w1, &w0, x[6], x[6]);
   z[12] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[13]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[12]);
   word3_muladd_2(&w0, &w2, &w1, x[2], x[11]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[10]);
   word3_muladd_2(&w0, &w2, &w1, x[4], x[9]);
   word3_muladd_2(&w0, &w2, &w1, x[5], x[8]);
   word3_muladd_2(&w0, &w2, &w1, x[6], x[7]);
   z[13] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[14]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[13]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[12]);
   word3_muladd_2(&w1, &w0, &w2, x[3], x[11]);
   word3_muladd_2(&w1, &w0, &w2, x[4], x[10]);
   word3_muladd_2(&w1, &w0, &w2, x[5], x[9]);
   word3_muladd_2(&w1, &w0, &w2, x[6], x[8]);
   word3_muladd(&w1, &w0, &w2, x[7], x[7]);
   z[14] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[15]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[14]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[13]);
   word3_muladd_2(&w2, &w1, &w0, x[3], x[12]);
   word3_muladd_2(&w2, &w1, &w0, x[4], x[11]);
   word3_muladd_2(&w2, &w1, &w0, x[5], x[10]);
   word3_muladd_2(&w2, &w1, &w0, x[6], x[9]);
   word3_muladd_2(&w2, &w1, &w0, x[7], x[8]);
   z[15] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[1], x[15]);
   word3_muladd_2(&w0, &w2, &w1, x[2], x[14]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[13]);
   word3_muladd_2(&w0, &w2, &w1, x[4], x[12]);
   word3_muladd_2(&w0, &w2, &w1, x[5], x[11]);
   word3_muladd_2(&w0, &w2, &w1, x[6], x[10]);
   word3_muladd_2(&w0, &w2, &w1, x[7], x[9]);
   word3_muladd(&w0, &w2, &w1, x[8], x[8]);
   z[16] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[2], x[15]);
   word3_muladd_2(&w1, &w0, &w2, x[3], x[14]);
   word3_muladd_2(&w1, &w0, &w2, x[4], x[13]);
   word3_muladd_2(&w1, &w0, &w2, x[5], x[12]);
   word3_muladd_2(&w1, &w0, &w2, x[6], x[11]);
   word3_muladd_2(&w1, &w0, &w2, x[7], x[10]);
   word3_muladd_2(&w1, &w0, &w2, x[8], x[9]);
   z[17] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[3], x[15]);
   word3_muladd_2(&w2, &w1, &w0, x[4], x[14]);
   word3_muladd_2(&w2, &w1, &w0, x[5], x[13]);
   word3_muladd_2(&w2, &w1, &w0, x[6], x[12]);
   word3_muladd_2(&w2, &w1, &w0, x[7], x[11]);
   word3_muladd_2(&w2, &w1, &w0, x[8], x[10]);
   word3_muladd(&w2, &w1, &w0, x[9], x[9]);
   z[18] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[4], x[15]);
   word3_muladd_2(&w0, &w2, &w1, x[5], x[14]);
   word3_muladd_2(&w0, &w2, &w1, x[6], x[13]);
   word3_muladd_2(&w0, &w2, &w1, x[7], x[12]);
   word3_muladd_2(&w0, &w2, &w1, x[8], x[11]);
   word3_muladd_2(&w0, &w2, &w1, x[9], x[10]);
   z[19] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[5], x[15]);
   word3_muladd_2(&w1, &w0, &w2, x[6], x[14]);
   word3_muladd_2(&w1, &w0, &w2, x[7], x[13]);
   word3_muladd_2(&w1, &w0, &w2, x[8], x[12]);
   word3_muladd_2(&w1, &w0, &w2, x[9], x[11]);
   word3_muladd(&w1, &w0, &w2, x[10], x[10]);
   z[20] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[6], x[15]);
   word3_muladd_2(&w2, &w1, &w0, x[7], x[14]);
   word3_muladd_2(&w2, &w1, &w0, x[8], x[13]);
   word3_muladd_2(&w2, &w1, &w0, x[9], x[12]);
   word3_muladd_2(&w2, &w1, &w0, x[10], x[11]);
   z[21] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[7], x[15]);
   word3_muladd_2(&w0, &w2, &w1, x[8], x[14]);
   word3_muladd_2(&w0, &w2, &w1, x[9], x[13]);
   word3_muladd_2(&w0, &w2, &w1, x[10], x[12]);
   word3_muladd(&w0, &w2, &w1, x[11], x[11]);
   z[22] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[8], x[15]);
   word3_muladd_2(&w1, &w0, &w2, x[9], x[14]);
   word3_muladd_2(&w1, &w0, &w2, x[10], x[13]);
   word3_muladd_2(&w1, &w0, &w2, x[11], x[12]);
   z[23] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[9], x[15]);
   word3_muladd_2(&w2, &w1, &w0, x[10], x[14]);
   word3_muladd_2(&w2, &w1, &w0, x[11], x[13]);
   word3_muladd(&w2, &w1, &w0, x[12], x[12]);
   z[24] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[10], x[15]);
   word3_muladd_2(&w0, &w2, &w1, x[11], x[14]);
   word3_muladd_2(&w0, &w2, &w1, x[12], x[13]);
   z[25] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[11], x[15]);
   word3_muladd_2(&w1, &w0, &w2, x[12], x[14]);
   word3_muladd(&w1, &w0, &w2, x[13], x[13]);
   z[26] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[12], x[15]);
   word3_muladd_2(&w2, &w1, &w0, x[13], x[14]);
   z[27] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[13], x[15]);
   word3_muladd(&w0, &w2, &w1, x[14], x[14]);
   z[28] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[14], x[15]);
   z[29] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[15], x[15]);
   z[30] = w0;
   z[31] = w1;
}

/*
* Comba 16x16 Multiplication
*/
void bigint_comba_mul16(word z[32], const word x[16], const word y[16]) {
   word w2 = 0, w1 = 0, w0 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[0]);
   z[0] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[1]);
   word3_muladd(&w0, &w2, &w1, x[1], y[0]);
   z[1] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[2]);
   word3_muladd(&w1, &w0, &w2, x[1], y[1]);
   word3_muladd(&w1, &w0, &w2, x[2], y[0]);
   z[2] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[3]);
   word3_muladd(&w2, &w1, &w0, x[1], y[2]);
   word3_muladd(&w2, &w1, &w0, x[2], y[1]);
   word3_muladd(&w2, &w1, &w0, x[3], y[0]);
   z[3] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[4]);
   word3_muladd(&w0, &w2, &w1, x[1], y[3]);
   word3_muladd(&w0, &w2, &w1, x[2], y[2]);
   word3_muladd(&w0, &w2, &w1, x[3], y[1]);
   word3_muladd(&w0, &w2, &w1, x[4], y[0]);
   z[4] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[5]);
   word3_muladd(&w1, &w0, &w2, x[1], y[4]);
   word3_muladd(&w1, &w0, &w2, x[2], y[3]);
   word3_muladd(&w1, &w0, &w2, x[3], y[2]);
   word3_muladd(&w1, &w0, &w2, x[4], y[1]);
   word3_muladd(&w1, &w0, &w2, x[5], y[0]);
   z[5] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[6]);
   word3_muladd(&w2, &w1, &w0, x[1], y[5]);
   word3_muladd(&w2, &w1, &w0, x[2], y[4]);
   word3_muladd(&w2, &w1, &w0, x[3], y[3]);
   word3_muladd(&w2, &w1, &w0, x[4], y[2]);
   word3_muladd(&w2, &w1, &w0, x[5], y[1]);
   word3_muladd(&w2, &w1, &w0, x[6], y[0]);
   z[6] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[7]);
   word3_muladd(&w0, &w2, &w1, x[1], y[6]);
   word3_muladd(&w0, &w2, &w1, x[2], y[5]);
   word3_muladd(&w0, &w2, &w1, x[3], y[4]);
   word3_muladd(&w0, &w2, &w1, x[4], y[3]);
   word3_muladd(&w0, &w2, &w1, x[5], y[2]);
   word3_muladd(&w0, &w2, &w1, x[6], y[1]);
   word3_muladd(&w0, &w2, &w1, x[7], y[0]);
   z[7] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[8]);
   word3_muladd(&w1, &w0, &w2, x[1], y[7]);
   word3_muladd(&w1, &w0, &w2, x[2], y[6]);
   word3_muladd(&w1, &w0, &w2, x[3], y[5]);
   word3_muladd(&w1, &w0, &w2, x[4], y[4]);
   word3_muladd(&w1, &w0, &w2, x[5], y[3]);
   word3_muladd(&w1, &w0, &w2, x[6], y[2]);
   word3_muladd(&w1, &w0, &w2, x[7], y[1]);
   word3_muladd(&w1, &w0, &w2, x[8], y[0]);
   z[8] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[9]);
   word3_muladd(&w2, &w1, &w0, x[1], y[8]);
   word3_muladd(&w2, &w1, &w0, x[2], y[7]);
   word3_muladd(&w2, &w1, &w0, x[3], y[6]);
   word3_muladd(&w2, &w1, &w0, x[4], y[5]);
   word3_muladd(&w2, &w1, &w0, x[5], y[4]);
   word3_muladd(&w2, &w1, &w0, x[6], y[3]);
   word3_muladd(&w2, &w1, &w0, x[7], y[2]);
   word3_muladd(&w2, &w1, &w0, x[8], y[1]);
   word3_muladd(&w2, &w1, &w0, x[9], y[0]);
   z[9] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[10]);
   word3_muladd(&w0, &w2, &w1, x[1], y[9]);
   word3_muladd(&w0, &w2, &w1, x[2], y[8]);
   word3_muladd(&w0, &w2, &w1, x[3], y[7]);
   word3_muladd(&w0, &w2, &w1, x[4], y[6]);
   word3_muladd(&w0, &w2, &w1, x[5], y[5]);
   word3_muladd(&w0, &w2, &w1, x[6], y[4]);
   word3_muladd(&w0, &w2, &w1, x[7], y[3]);
   word3_muladd(&w0, &w2, &w1, x[8], y[2]);
   word3_muladd(&w0, &w2, &w1, x[9], y[1]);
   word3_muladd(&w0, &w2, &w1, x[10], y[0]);
   z[10] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[11]);
   word3_muladd(&w1, &w0, &w2, x[1], y[10]);
   word3_muladd(&w1, &w0, &w2, x[2], y[9]);
   word3_muladd(&w1, &w0, &w2, x[3], y[8]);
   word3_muladd(&w1, &w0, &w2, x[4], y[7]);
   word3_muladd(&w1, &w0, &w2, x[5], y[6]);
   word3_muladd(&w1, &w0, &w2, x[6], y[5]);
   word3_muladd(&w1, &w0, &w2, x[7], y[4]);
   word3_muladd(&w1, &w0, &w2, x[8], y[3]);
   word3_muladd(&w1, &w0, &w2, x[9], y[2]);
   word3_muladd(&w1, &w0, &w2, x[10], y[1]);
   word3_muladd(&w1, &w0, &w2, x[11], y[0]);
   z[11] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[12]);
   word3_muladd(&w2, &w1, &w0, x[1], y[11]);
   word3_muladd(&w2, &w1, &w0, x[2], y[10]);
   word3_muladd(&w2, &w1, &w0, x[3], y[9]);
   word3_muladd(&w2, &w1, &w0, x[4], y[8]);
   word3_muladd(&w2, &w1, &w0, x[5], y[7]);
   word3_muladd(&w2, &w1, &w0, x[6], y[6]);
   word3_muladd(&w2, &w1, &w0, x[7], y[5]);
   word3_muladd(&w2, &w1, &w0, x[8], y[4]);
   word3_muladd(&w2, &w1, &w0, x[9], y[3]);
   word3_muladd(&w2, &w1, &w0, x[10], y[2]);
   word3_muladd(&w2, &w1, &w0, x[11], y[1]);
   word3_muladd(&w2, &w1, &w0, x[12], y[0]);
   z[12] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[13]);
   word3_muladd(&w0, &w2, &w1, x[1], y[12]);
   word3_muladd(&w0, &w2, &w1, x[2], y[11]);
   word3_muladd(&w0, &w2, &w1, x[3], y[10]);
   word3_muladd(&w0, &w2, &w1, x[4], y[9]);
   word3_muladd(&w0, &w2, &w1, x[5], y[8]);
   word3_muladd(&w0, &w2, &w1, x[6], y[7]);
   word3_muladd(&w0, &w2, &w1, x[7], y[6]);
   word3_muladd(&w0, &w2, &w1, x[8], y[5]);
   word3_muladd(&w0, &w2, &w1, x[9], y[4]);
   word3_muladd(&w0, &w2, &w1, x[10], y[3]);
   word3_muladd(&w0, &w2, &w1, x[11], y[2]);
   word3_muladd(&w0, &w2, &w1, x[12], y[1]);
   word3_muladd(&w0, &w2, &w1, x[13], y[0]);
   z[13] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[14]);
   word3_muladd(&w1, &w0, &w2, x[1], y[13]);
   word3_muladd(&w1, &w0, &w2, x[2], y[12]);
   word3_muladd(&w1, &w0, &w2, x[3], y[11]);
   word3_muladd(&w1, &w0, &w2, x[4], y[10]);
   word3_muladd(&w1, &w0, &w2, x[5], y[9]);
   word3_muladd(&w1, &w0, &w2, x[6], y[8]);
   word3_muladd(&w1, &w0, &w2, x[7], y[7]);
   word3_muladd(&w1, &w0, &w2, x[8], y[6]);
   word3_muladd(&w1, &w0, &w2, x[9], y[5]);
   word3_muladd(&w1, &w0, &w2, x[10], y[4]);
   word3_muladd(&w1, &w0, &w2, x[11], y[3]);
   word3_muladd(&w1, &w0, &w2, x[12], y[2]);
   word3_muladd(&w1, &w0, &w2, x[13], y[1]);
   word3_muladd(&w1, &w0, &w2, x[14], y[0]);
   z[14] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[15]);
   word3_muladd(&w2, &w1, &w0, x[1], y[14]);
   word3_muladd(&w2, &w1, &w0, x[2], y[13]);
   word3_muladd(&w2, &w1, &w0, x[3], y[12]);
   word3_muladd(&w2, &w1, &w0, x[4], y[11]);
   word3_muladd(&w2, &w1, &w0, x[5], y[10]);
   word3_muladd(&w2, &w1, &w0, x[6], y[9]);
   word3_muladd(&w2, &w1, &w0, x[7], y[8]);
   word3_muladd(&w2, &w1, &w0, x[8], y[7]);
   word3_muladd(&w2, &w1, &w0, x[9], y[6]);
   word3_muladd(&w2, &w1, &w0, x[10], y[5]);
   word3_muladd(&w2, &w1, &w0, x[11], y[4]);
   word3_muladd(&w2, &w1, &w0, x[12], y[3]);
   word3_muladd(&w2, &w1, &w0, x[13], y[2]);
   word3_muladd(&w2, &w1, &w0, x[14], y[1]);
   word3_muladd(&w2, &w1, &w0, x[15], y[0]);
   z[15] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[1], y[15]);
   word3_muladd(&w0, &w2, &w1, x[2], y[14]);
   word3_muladd(&w0, &w2, &w1, x[3], y[13]);
   word3_muladd(&w0, &w2, &w1, x[4], y[12]);
   word3_muladd(&w0, &w2, &w1, x[5], y[11]);
   word3_muladd(&w0, &w2, &w1, x[6], y[10]);
   word3_muladd(&w0, &w2, &w1, x[7], y[9]);
   word3_muladd(&w0, &w2, &w1, x[8], y[8]);
   word3_muladd(&w0, &w2, &w1, x[9], y[7]);
   word3_muladd(&w0, &w2, &w1, x[10], y[6]);
   word3_muladd(&w0, &w2, &w1, x[11], y[5]);
   word3_muladd(&w0, &w2, &w1, x[12], y[4]);
   word3_muladd(&w0, &w2, &w1, x[13], y[3]);
   word3_muladd(&w0, &w2, &w1, x[14], y[2]);
   word3_muladd(&w0, &w2, &w1, x[15], y[1]);
   z[16] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[2], y[15]);
   word3_muladd(&w1, &w0, &w2, x[3], y[14]);
   word3_muladd(&w1, &w0, &w2, x[4], y[13]);
   word3_muladd(&w1, &w0, &w2, x[5], y[12]);
   word3_muladd(&w1, &w0, &w2, x[6], y[11]);
   word3_muladd(&w1, &w0, &w2, x[7], y[10]);
   word3_muladd(&w1, &w0, &w2, x[8], y[9]);
   word3_muladd(&w1, &w0, &w2, x[9], y[8]);
   word3_muladd(&w1, &w0, &w2, x[10], y[7]);
   word3_muladd(&w1, &w0, &w2, x[11], y[6]);
   word3_muladd(&w1, &w0, &w2, x[12], y[5]);
   word3_muladd(&w1, &w0, &w2, x[13], y[4]);
   word3_muladd(&w1, &w0, &w2, x[14], y[3]);
   word3_muladd(&w1, &w0, &w2, x[15], y[2]);
   z[17] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[3], y[15]);
   word3_muladd(&w2, &w1, &w0, x[4], y[14]);
   word3_muladd(&w2, &w1, &w0, x[5], y[13]);
   word3_muladd(&w2, &w1, &w0, x[6], y[12]);
   word3_muladd(&w2, &w1, &w0, x[7], y[11]);
   word3_muladd(&w2, &w1, &w0, x[8], y[10]);
   word3_muladd(&w2, &w1, &w0, x[9], y[9]);
   word3_muladd(&w2, &w1, &w0, x[10], y[8]);
   word3_muladd(&w2, &w1, &w0, x[11], y[7]);
   word3_muladd(&w2, &w1, &w0, x[12], y[6]);
   word3_muladd(&w2, &w1, &w0, x[13], y[5]);
   word3_muladd(&w2, &w1, &w0, x[14], y[4]);
   word3_muladd(&w2, &w1, &w0, x[15], y[3]);
   z[18] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[4], y[15]);
   word3_muladd(&w0, &w2, &w1, x[5], y[14]);
   word3_muladd(&w0, &w2, &w1, x[6], y[13]);
   word3_muladd(&w0, &w2, &w1, x[7], y[12]);
   word3_muladd(&w0, &w2, &w1, x[8], y[11]);
   word3_muladd(&w0, &w2, &w1, x[9], y[10]);
   word3_muladd(&w0, &w2, &w1, x[10], y[9]);
   word3_muladd(&w0, &w2, &w1, x[11], y[8]);
   word3_muladd(&w0, &w2, &w1, x[12], y[7]);
   word3_muladd(&w0, &w2, &w1, x[13], y[6]);
   word3_muladd(&w0, &w2, &w1, x[14], y[5]);
   word3_muladd(&w0, &w2, &w1, x[15], y[4]);
   z[19] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[5], y[15]);
   word3_muladd(&w1, &w0, &w2, x[6], y[14]);
   word3_muladd(&w1, &w0, &w2, x[7], y[13]);
   word3_muladd(&w1, &w0, &w2, x[8], y[12]);
   word3_muladd(&w1, &w0, &w2, x[9], y[11]);
   word3_muladd(&w1, &w0, &w2, x[10], y[10]);
   word3_muladd(&w1, &w0, &w2, x[11], y[9]);
   word3_muladd(&w1, &w0, &w2, x[12], y[8]);
   word3_muladd(&w1, &w0, &w2, x[13], y[7]);
   word3_muladd(&w1, &w0, &w2, x[14], y[6]);
   word3_muladd(&w1, &w0, &w2, x[15], y[5]);
   z[20] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[6], y[15]);
   word3_muladd(&w2, &w1, &w0, x[7], y[14]);
   word3_muladd(&w2, &w1, &w0, x[8], y[13]);
   word3_muladd(&w2, &w1, &w0, x[9], y[12]);
   word3_muladd(&w2, &w1, &w0, x[10], y[11]);
   word3_muladd(&w2, &w1, &w0, x[11], y[10]);
   word3_muladd(&w2, &w1, &w0, x[12], y[9]);
   word3_muladd(&w2, &w1, &w0, x[13], y[8]);
   word3_muladd(&w2, &w1, &w0, x[14], y[7]);
   word3_muladd(&w2, &w1, &w0, x[15], y[6]);
   z[21] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[7], y[15]);
   word3_muladd(&w0, &w2, &w1, x[8], y[14]);
   word3_muladd(&w0, &w2, &w1, x[9], y[13]);
   word3_muladd(&w0, &w2, &w1, x[10], y[12]);
   word3_muladd(&w0, &w2, &w1, x[11], y[11]);
   word3_muladd(&w0, &w2, &w1, x[12], y[10]);
   word3_muladd(&w0, &w2, &w1, x[13], y[9]);
   word3_muladd(&w0, &w2, &w1, x[14], y[8]);
   word3_muladd(&w0, &w2, &w1, x[15], y[7]);
   z[22] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[8], y[15]);
   word3_muladd(&w1, &w0, &w2, x[9], y[14]);
   word3_muladd(&w1, &w0, &w2, x[10], y[13]);
   word3_muladd(&w1, &w0, &w2, x[11], y[12]);
   word3_muladd(&w1, &w0, &w2, x[12], y[11]);
   word3_muladd(&w1, &w0, &w2, x[13], y[10]);
   word3_muladd(&w1, &w0, &w2, x[14], y[9]);
   word3_muladd(&w1, &w0, &w2, x[15], y[8]);
   z[23] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[9], y[15]);
   word3_muladd(&w2, &w1, &w0, x[10], y[14]);
   word3_muladd(&w2, &w1, &w0, x[11], y[13]);
   word3_muladd(&w2, &w1, &w0, x[12], y[12]);
   word3_muladd(&w2, &w1, &w0, x[13], y[11]);
   word3_muladd(&w2, &w1, &w0, x[14], y[10]);
   word3_muladd(&w2, &w1, &w0, x[15], y[9]);
   z[24] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[10], y[15]);
   word3_muladd(&w0, &w2, &w1, x[11], y[14]);
   word3_muladd(&w0, &w2, &w1, x[12], y[13]);
   word3_muladd(&w0, &w2, &w1, x[13], y[12]);
   word3_muladd(&w0, &w2, &w1, x[14], y[11]);
   word3_muladd(&w0, &w2, &w1, x[15], y[10]);
   z[25] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[11], y[15]);
   word3_muladd(&w1, &w0, &w2, x[12], y[14]);
   word3_muladd(&w1, &w0, &w2, x[13], y[13]);
   word3_muladd(&w1, &w0, &w2, x[14], y[12]);
   word3_muladd(&w1, &w0, &w2, x[15], y[11]);
   z[26] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[12], y[15]);
   word3_muladd(&w2, &w1, &w0, x[13], y[14]);
   word3_muladd(&w2, &w1, &w0, x[14], y[13]);
   word3_muladd(&w2, &w1, &w0, x[15], y[12]);
   z[27] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[13], y[15]);
   word3_muladd(&w0, &w2, &w1, x[14], y[14]);
   word3_muladd(&w0, &w2, &w1, x[15], y[13]);
   z[28] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[14], y[15]);
   word3_muladd(&w1, &w0, &w2, x[15], y[14]);
   z[29] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[15], y[15]);
   z[30] = w0;
   z[31] = w1;
}

/*
* Comba 24x24 Squaring
*/
void bigint_comba_sqr24(word z[48], const word x[24]) {
   word w2 = 0, w1 = 0, w0 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], x[0]);
   z[0] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[1]);
   z[1] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[2]);
   word3_muladd(&w1, &w0, &w2, x[1], x[1]);
   z[2] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[3]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[2]);
   z[3] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[4]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[3]);
   word3_muladd(&w0, &w2, &w1, x[2], x[2]);
   z[4] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[5]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[4]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[3]);
   z[5] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[6]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[5]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[4]);
   word3_muladd(&w2, &w1, &w0, x[3], x[3]);
   z[6] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[7]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[6]);
   word3_muladd_2(&w0, &w2, &w1, x[2], x[5]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[4]);
   z[7] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[8]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[7]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[6]);
   word3_muladd_2(&w1, &w0, &w2, x[3], x[5]);
   word3_muladd(&w1, &w0, &w2, x[4], x[4]);
   z[8] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[9]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[8]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[7]);
   word3_muladd_2(&w2, &w1, &w0, x[3], x[6]);
   word3_muladd_2(&w2, &w1, &w0, x[4], x[5]);
   z[9] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[10]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[9]);
   word3_muladd_2(&w0, &w2, &w1, x[2], x[8]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[7]);
   word3_muladd_2(&w0, &w2, &w1, x[4], x[6]);
   word3_muladd(&w0, &w2, &w1, x[5], x[5]);
   z[10] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[11]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[10]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[9]);
   word3_muladd_2(&w1, &w0, &w2, x[3], x[8]);
   word3_muladd_2(&w1, &w0, &w2, x[4], x[7]);
   word3_muladd_2(&w1, &w0, &w2, x[5], x[6]);
   z[11] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[12]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[11]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[10]);
   word3_muladd_2(&w2, &w1, &w0, x[3], x[9]);
   word3_muladd_2(&w2, &w1, &w0, x[4], x[8]);
   word3_muladd_2(&w2, &w1, &w0, x[5], x[7]);
   word3_muladd(&w2, &w1, &w0, x[6], x[6]);
   z[12] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[13]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[12]);
   word3_muladd_2(&w0, &w2, &w1, x[2], x[11]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[10]);
   word3_muladd_2(&w0, &w2, &w1, x[4], x[9]);
   word3_muladd_2(&w0, &w2, &w1, x[5], x[8]);
   word3_muladd_2(&w0, &w2, &w1, x[6], x[7]);
   z[13] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[14]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[13]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[12]);
   word3_muladd_2(&w1, &w0, &w2, x[3], x[11]);
   word3_muladd_2(&w1, &w0, &w2, x[4], x[10]);
   word3_muladd_2(&w1, &w0, &w2, x[5], x[9]);
   word3_muladd_2(&w1, &w0, &w2, x[6], x[8]);
   word3_muladd(&w1, &w0, &w2, x[7], x[7]);
   z[14] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[15]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[14]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[13]);
   word3_muladd_2(&w2, &w1, &w0, x[3], x[12]);
   word3_muladd_2(&w2, &w1, &w0, x[4], x[11]);
   word3_muladd_2(&w2, &w1, &w0, x[5], x[10]);
   word3_muladd_2(&w2, &w1, &w0, x[6], x[9]);
   word3_muladd_2(&w2, &w1, &w0, x[7], x[8]);
   z[15] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[16]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[15]);
   word3_muladd_2(&w0, &w2, &w1, x[2], x[14]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[13]);
   word3_muladd_2(&w0, &w2, &w1, x[4], x[12]);
   word3_muladd_2(&w0, &w2, &w1, x[5], x[11]);
   word3_muladd_2(&w0, &w2, &w1, x[6], x[10]);
   word3_muladd_2(&w0, &w2, &w1, x[7], x[9]);
   word3_muladd(&w0, &w2, &w1, x[8], x[8]);
   z[16] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[17]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[16]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[15]);
   word3_muladd_2(&w1, &w0, &w2, x[3], x[14]);
   word3_muladd_2(&w1, &w0, &w2, x[4], x[13]);
   word3_muladd_2(&w1, &w0, &w2, x[5], x[12]);
   word3_muladd_2(&w1, &w0, &w2, x[6], x[11]);
   word3_muladd_2(&w1, &w0, &w2, x[7], x[10]);
   word3_muladd_2(&w1, &w0, &w2, x[8], x[9]);
   z[17] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[18]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[17]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[16]);
   word3_muladd_2(&w2, &w1, &w0, x[3], x[15]);
   word3_muladd_2(&w2, &w1, &w0, x[4], x[14]);
   word3_muladd_2(&w2, &w1, &w0, x[5], x[13]);
   word3_muladd_2(&w2, &w1, &w0, x[6], x[12]);
   word3_muladd_2(&w2, &w1, &w0, x[7], x[11]);
   word3_muladd_2(&w2, &w1, &w0, x[8], x[10]);
   word3_muladd(&w2, &w1, &w0, x[9], x[9]);
   z[18] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[19]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[18]);
   word3_muladd_2(&w0, &w2, &w1, x[2], x[17]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[16]);
   word3_muladd_2(&w0, &w2, &w1, x[4], x[15]);
   word3_muladd_2(&w0, &w2, &w1, x[5], x[14]);
   word3_muladd_2(&w0, &w2, &w1, x[6], x[13]);
   word3_muladd_2(&w0, &w2, &w1, x[7], x[12]);
   word3_muladd_2(&w0, &w2, &w1, x[8], x[11]);
   word3_muladd_2(&w0, &w2, &w1, x[9], x[10]);
   z[19] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[20]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[19]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[18]);
   word3_muladd_2(&w1, &w0, &w2, x[3], x[17]);
   word3_muladd_2(&w1, &w0, &w2, x[4], x[16]);
   word3_muladd_2(&w1, &w0, &w2, x[5], x[15]);
   word3_muladd_2(&w1, &w0, &w2, x[6], x[14]);
   word3_muladd_2(&w1, &w0, &w2, x[7], x[13]);
   word3_muladd_2(&w1, &w0, &w2, x[8], x[12]);
   word3_muladd_2(&w1, &w0, &w2, x[9], x[11]);
   word3_muladd(&w1, &w0, &w2, x[10], x[10]);
   z[20] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[0], x[21]);
   word3_muladd_2(&w2, &w1, &w0, x[1], x[20]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[19]);
   word3_muladd_2(&w2, &w1, &w0, x[3], x[18]);
   word3_muladd_2(&w2, &w1, &w0, x[4], x[17]);
   word3_muladd_2(&w2, &w1, &w0, x[5], x[16]);
   word3_muladd_2(&w2, &w1, &w0, x[6], x[15]);
   word3_muladd_2(&w2, &w1, &w0, x[7], x[14]);
   word3_muladd_2(&w2, &w1, &w0, x[8], x[13]);
   word3_muladd_2(&w2, &w1, &w0, x[9], x[12]);
   word3_muladd_2(&w2, &w1, &w0, x[10], x[11]);
   z[21] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[0], x[22]);
   word3_muladd_2(&w0, &w2, &w1, x[1], x[21]);
   word3_muladd_2(&w0, &w2, &w1, x[2], x[20]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[19]);
   word3_muladd_2(&w0, &w2, &w1, x[4], x[18]);
   word3_muladd_2(&w0, &w2, &w1, x[5], x[17]);
   word3_muladd_2(&w0, &w2, &w1, x[6], x[16]);
   word3_muladd_2(&w0, &w2, &w1, x[7], x[15]);
   word3_muladd_2(&w0, &w2, &w1, x[8], x[14]);
   word3_muladd_2(&w0, &w2, &w1, x[9], x[13]);
   word3_muladd_2(&w0, &w2, &w1, x[10], x[12]);
   word3_muladd(&w0, &w2, &w1, x[11], x[11]);
   z[22] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[0], x[23]);
   word3_muladd_2(&w1, &w0, &w2, x[1], x[22]);
   word3_muladd_2(&w1, &w0, &w2, x[2], x[21]);
   word3_muladd_2(&w1, &w0, &w2, x[3], x[20]);
   word3_muladd_2(&w1, &w0, &w2, x[4], x[19]);
   word3_muladd_2(&w1, &w0, &w2, x[5], x[18]);
   word3_muladd_2(&w1, &w0, &w2, x[6], x[17]);
   word3_muladd_2(&w1, &w0, &w2, x[7], x[16]);
   word3_muladd_2(&w1, &w0, &w2, x[8], x[15]);
   word3_muladd_2(&w1, &w0, &w2, x[9], x[14]);
   word3_muladd_2(&w1, &w0, &w2, x[10], x[13]);
   word3_muladd_2(&w1, &w0, &w2, x[11], x[12]);
   z[23] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[1], x[23]);
   word3_muladd_2(&w2, &w1, &w0, x[2], x[22]);
   word3_muladd_2(&w2, &w1, &w0, x[3], x[21]);
   word3_muladd_2(&w2, &w1, &w0, x[4], x[20]);
   word3_muladd_2(&w2, &w1, &w0, x[5], x[19]);
   word3_muladd_2(&w2, &w1, &w0, x[6], x[18]);
   word3_muladd_2(&w2, &w1, &w0, x[7], x[17]);
   word3_muladd_2(&w2, &w1, &w0, x[8], x[16]);
   word3_muladd_2(&w2, &w1, &w0, x[9], x[15]);
   word3_muladd_2(&w2, &w1, &w0, x[10], x[14]);
   word3_muladd_2(&w2, &w1, &w0, x[11], x[13]);
   word3_muladd(&w2, &w1, &w0, x[12], x[12]);
   z[24] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[2], x[23]);
   word3_muladd_2(&w0, &w2, &w1, x[3], x[22]);
   word3_muladd_2(&w0, &w2, &w1, x[4], x[21]);
   word3_muladd_2(&w0, &w2, &w1, x[5], x[20]);
   word3_muladd_2(&w0, &w2, &w1, x[6], x[19]);
   word3_muladd_2(&w0, &w2, &w1, x[7], x[18]);
   word3_muladd_2(&w0, &w2, &w1, x[8], x[17]);
   word3_muladd_2(&w0, &w2, &w1, x[9], x[16]);
   word3_muladd_2(&w0, &w2, &w1, x[10], x[15]);
   word3_muladd_2(&w0, &w2, &w1, x[11], x[14]);
   word3_muladd_2(&w0, &w2, &w1, x[12], x[13]);
   z[25] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[3], x[23]);
   word3_muladd_2(&w1, &w0, &w2, x[4], x[22]);
   word3_muladd_2(&w1, &w0, &w2, x[5], x[21]);
   word3_muladd_2(&w1, &w0, &w2, x[6], x[20]);
   word3_muladd_2(&w1, &w0, &w2, x[7], x[19]);
   word3_muladd_2(&w1, &w0, &w2, x[8], x[18]);
   word3_muladd_2(&w1, &w0, &w2, x[9], x[17]);
   word3_muladd_2(&w1, &w0, &w2, x[10], x[16]);
   word3_muladd_2(&w1, &w0, &w2, x[11], x[15]);
   word3_muladd_2(&w1, &w0, &w2, x[12], x[14]);
   word3_muladd(&w1, &w0, &w2, x[13], x[13]);
   z[26] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[4], x[23]);
   word3_muladd_2(&w2, &w1, &w0, x[5], x[22]);
   word3_muladd_2(&w2, &w1, &w0, x[6], x[21]);
   word3_muladd_2(&w2, &w1, &w0, x[7], x[20]);
   word3_muladd_2(&w2, &w1, &w0, x[8], x[19]);
   word3_muladd_2(&w2, &w1, &w0, x[9], x[18]);
   word3_muladd_2(&w2, &w1, &w0, x[10], x[17]);
   word3_muladd_2(&w2, &w1, &w0, x[11], x[16]);
   word3_muladd_2(&w2, &w1, &w0, x[12], x[15]);
   word3_muladd_2(&w2, &w1, &w0, x[13], x[14]);
   z[27] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[5], x[23]);
   word3_muladd_2(&w0, &w2, &w1, x[6], x[22]);
   word3_muladd_2(&w0, &w2, &w1, x[7], x[21]);
   word3_muladd_2(&w0, &w2, &w1, x[8], x[20]);
   word3_muladd_2(&w0, &w2, &w1, x[9], x[19]);
   word3_muladd_2(&w0, &w2, &w1, x[10], x[18]);
   word3_muladd_2(&w0, &w2, &w1, x[11], x[17]);
   word3_muladd_2(&w0, &w2, &w1, x[12], x[16]);
   word3_muladd_2(&w0, &w2, &w1, x[13], x[15]);
   word3_muladd(&w0, &w2, &w1, x[14], x[14]);
   z[28] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[6], x[23]);
   word3_muladd_2(&w1, &w0, &w2, x[7], x[22]);
   word3_muladd_2(&w1, &w0, &w2, x[8], x[21]);
   word3_muladd_2(&w1, &w0, &w2, x[9], x[20]);
   word3_muladd_2(&w1, &w0, &w2, x[10], x[19]);
   word3_muladd_2(&w1, &w0, &w2, x[11], x[18]);
   word3_muladd_2(&w1, &w0, &w2, x[12], x[17]);
   word3_muladd_2(&w1, &w0, &w2, x[13], x[16]);
   word3_muladd_2(&w1, &w0, &w2, x[14], x[15]);
   z[29] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[7], x[23]);
   word3_muladd_2(&w2, &w1, &w0, x[8], x[22]);
   word3_muladd_2(&w2, &w1, &w0, x[9], x[21]);
   word3_muladd_2(&w2, &w1, &w0, x[10], x[20]);
   word3_muladd_2(&w2, &w1, &w0, x[11], x[19]);
   word3_muladd_2(&w2, &w1, &w0, x[12], x[18]);
   word3_muladd_2(&w2, &w1, &w0, x[13], x[17]);
   word3_muladd_2(&w2, &w1, &w0, x[14], x[16]);
   word3_muladd(&w2, &w1, &w0, x[15], x[15]);
   z[30] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[8], x[23]);
   word3_muladd_2(&w0, &w2, &w1, x[9], x[22]);
   word3_muladd_2(&w0, &w2, &w1, x[10], x[21]);
   word3_muladd_2(&w0, &w2, &w1, x[11], x[20]);
   word3_muladd_2(&w0, &w2, &w1, x[12], x[19]);
   word3_muladd_2(&w0, &w2, &w1, x[13], x[18]);
   word3_muladd_2(&w0, &w2, &w1, x[14], x[17]);
   word3_muladd_2(&w0, &w2, &w1, x[15], x[16]);
   z[31] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[9], x[23]);
   word3_muladd_2(&w1, &w0, &w2, x[10], x[22]);
   word3_muladd_2(&w1, &w0, &w2, x[11], x[21]);
   word3_muladd_2(&w1, &w0, &w2, x[12], x[20]);
   word3_muladd_2(&w1, &w0, &w2, x[13], x[19]);
   word3_muladd_2(&w1, &w0, &w2, x[14], x[18]);
   word3_muladd_2(&w1, &w0, &w2, x[15], x[17]);
   word3_muladd(&w1, &w0, &w2, x[16], x[16]);
   z[32] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[10], x[23]);
   word3_muladd_2(&w2, &w1, &w0, x[11], x[22]);
   word3_muladd_2(&w2, &w1, &w0, x[12], x[21]);
   word3_muladd_2(&w2, &w1, &w0, x[13], x[20]);
   word3_muladd_2(&w2, &w1, &w0, x[14], x[19]);
   word3_muladd_2(&w2, &w1, &w0, x[15], x[18]);
   word3_muladd_2(&w2, &w1, &w0, x[16], x[17]);
   z[33] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[11], x[23]);
   word3_muladd_2(&w0, &w2, &w1, x[12], x[22]);
   word3_muladd_2(&w0, &w2, &w1, x[13], x[21]);
   word3_muladd_2(&w0, &w2, &w1, x[14], x[20]);
   word3_muladd_2(&w0, &w2, &w1, x[15], x[19]);
   word3_muladd_2(&w0, &w2, &w1, x[16], x[18]);
   word3_muladd(&w0, &w2, &w1, x[17], x[17]);
   z[34] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[12], x[23]);
   word3_muladd_2(&w1, &w0, &w2, x[13], x[22]);
   word3_muladd_2(&w1, &w0, &w2, x[14], x[21]);
   word3_muladd_2(&w1, &w0, &w2, x[15], x[20]);
   word3_muladd_2(&w1, &w0, &w2, x[16], x[19]);
   word3_muladd_2(&w1, &w0, &w2, x[17], x[18]);
   z[35] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[13], x[23]);
   word3_muladd_2(&w2, &w1, &w0, x[14], x[22]);
   word3_muladd_2(&w2, &w1, &w0, x[15], x[21]);
   word3_muladd_2(&w2, &w1, &w0, x[16], x[20]);
   word3_muladd_2(&w2, &w1, &w0, x[17], x[19]);
   word3_muladd(&w2, &w1, &w0, x[18], x[18]);
   z[36] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[14], x[23]);
   word3_muladd_2(&w0, &w2, &w1, x[15], x[22]);
   word3_muladd_2(&w0, &w2, &w1, x[16], x[21]);
   word3_muladd_2(&w0, &w2, &w1, x[17], x[20]);
   word3_muladd_2(&w0, &w2, &w1, x[18], x[19]);
   z[37] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[15], x[23]);
   word3_muladd_2(&w1, &w0, &w2, x[16], x[22]);
   word3_muladd_2(&w1, &w0, &w2, x[17], x[21]);
   word3_muladd_2(&w1, &w0, &w2, x[18], x[20]);
   word3_muladd(&w1, &w0, &w2, x[19], x[19]);
   z[38] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[16], x[23]);
   word3_muladd_2(&w2, &w1, &w0, x[17], x[22]);
   word3_muladd_2(&w2, &w1, &w0, x[18], x[21]);
   word3_muladd_2(&w2, &w1, &w0, x[19], x[20]);
   z[39] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[17], x[23]);
   word3_muladd_2(&w0, &w2, &w1, x[18], x[22]);
   word3_muladd_2(&w0, &w2, &w1, x[19], x[21]);
   word3_muladd(&w0, &w2, &w1, x[20], x[20]);
   z[40] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[18], x[23]);
   word3_muladd_2(&w1, &w0, &w2, x[19], x[22]);
   word3_muladd_2(&w1, &w0, &w2, x[20], x[21]);
   z[41] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[19], x[23]);
   word3_muladd_2(&w2, &w1, &w0, x[20], x[22]);
   word3_muladd(&w2, &w1, &w0, x[21], x[21]);
   z[42] = w0;
   w0 = 0;

   word3_muladd_2(&w0, &w2, &w1, x[20], x[23]);
   word3_muladd_2(&w0, &w2, &w1, x[21], x[22]);
   z[43] = w1;
   w1 = 0;

   word3_muladd_2(&w1, &w0, &w2, x[21], x[23]);
   word3_muladd(&w1, &w0, &w2, x[22], x[22]);
   z[44] = w2;
   w2 = 0;

   word3_muladd_2(&w2, &w1, &w0, x[22], x[23]);
   z[45] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[23], x[23]);
   z[46] = w1;
   z[47] = w2;
}

/*
* Comba 24x24 Multiplication
*/
void bigint_comba_mul24(word z[48], const word x[24], const word y[24]) {
   word w2 = 0, w1 = 0, w0 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[0]);
   z[0] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[1]);
   word3_muladd(&w0, &w2, &w1, x[1], y[0]);
   z[1] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[2]);
   word3_muladd(&w1, &w0, &w2, x[1], y[1]);
   word3_muladd(&w1, &w0, &w2, x[2], y[0]);
   z[2] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[3]);
   word3_muladd(&w2, &w1, &w0, x[1], y[2]);
   word3_muladd(&w2, &w1, &w0, x[2], y[1]);
   word3_muladd(&w2, &w1, &w0, x[3], y[0]);
   z[3] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[4]);
   word3_muladd(&w0, &w2, &w1, x[1], y[3]);
   word3_muladd(&w0, &w2, &w1, x[2], y[2]);
   word3_muladd(&w0, &w2, &w1, x[3], y[1]);
   word3_muladd(&w0, &w2, &w1, x[4], y[0]);
   z[4] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[5]);
   word3_muladd(&w1, &w0, &w2, x[1], y[4]);
   word3_muladd(&w1, &w0, &w2, x[2], y[3]);
   word3_muladd(&w1, &w0, &w2, x[3], y[2]);
   word3_muladd(&w1, &w0, &w2, x[4], y[1]);
   word3_muladd(&w1, &w0, &w2, x[5], y[0]);
   z[5] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[6]);
   word3_muladd(&w2, &w1, &w0, x[1], y[5]);
   word3_muladd(&w2, &w1, &w0, x[2], y[4]);
   word3_muladd(&w2, &w1, &w0, x[3], y[3]);
   word3_muladd(&w2, &w1, &w0, x[4], y[2]);
   word3_muladd(&w2, &w1, &w0, x[5], y[1]);
   word3_muladd(&w2, &w1, &w0, x[6], y[0]);
   z[6] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[7]);
   word3_muladd(&w0, &w2, &w1, x[1], y[6]);
   word3_muladd(&w0, &w2, &w1, x[2], y[5]);
   word3_muladd(&w0, &w2, &w1, x[3], y[4]);
   word3_muladd(&w0, &w2, &w1, x[4], y[3]);
   word3_muladd(&w0, &w2, &w1, x[5], y[2]);
   word3_muladd(&w0, &w2, &w1, x[6], y[1]);
   word3_muladd(&w0, &w2, &w1, x[7], y[0]);
   z[7] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[8]);
   word3_muladd(&w1, &w0, &w2, x[1], y[7]);
   word3_muladd(&w1, &w0, &w2, x[2], y[6]);
   word3_muladd(&w1, &w0, &w2, x[3], y[5]);
   word3_muladd(&w1, &w0, &w2, x[4], y[4]);
   word3_muladd(&w1, &w0, &w2, x[5], y[3]);
   word3_muladd(&w1, &w0, &w2, x[6], y[2]);
   word3_muladd(&w1, &w0, &w2, x[7], y[1]);
   word3_muladd(&w1, &w0, &w2, x[8], y[0]);
   z[8] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[9]);
   word3_muladd(&w2, &w1, &w0, x[1], y[8]);
   word3_muladd(&w2, &w1, &w0, x[2], y[7]);
   word3_muladd(&w2, &w1, &w0, x[3], y[6]);
   word3_muladd(&w2, &w1, &w0, x[4], y[5]);
   word3_muladd(&w2, &w1, &w0, x[5], y[4]);
   word3_muladd(&w2, &w1, &w0, x[6], y[3]);
   word3_muladd(&w2, &w1, &w0, x[7], y[2]);
   word3_muladd(&w2, &w1, &w0, x[8], y[1]);
   word3_muladd(&w2, &w1, &w0, x[9], y[0]);
   z[9] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[10]);
   word3_muladd(&w0, &w2, &w1, x[1], y[9]);
   word3_muladd(&w0, &w2, &w1, x[2], y[8]);
   word3_muladd(&w0, &w2, &w1, x[3], y[7]);
   word3_muladd(&w0, &w2, &w1, x[4], y[6]);
   word3_muladd(&w0, &w2, &w1, x[5], y[5]);
   word3_muladd(&w0, &w2, &w1, x[6], y[4]);
   word3_muladd(&w0, &w2, &w1, x[7], y[3]);
   word3_muladd(&w0, &w2, &w1, x[8], y[2]);
   word3_muladd(&w0, &w2, &w1, x[9], y[1]);
   word3_muladd(&w0, &w2, &w1, x[10], y[0]);
   z[10] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[11]);
   word3_muladd(&w1, &w0, &w2, x[1], y[10]);
   word3_muladd(&w1, &w0, &w2, x[2], y[9]);
   word3_muladd(&w1, &w0, &w2, x[3], y[8]);
   word3_muladd(&w1, &w0, &w2, x[4], y[7]);
   word3_muladd(&w1, &w0, &w2, x[5], y[6]);
   word3_muladd(&w1, &w0, &w2, x[6], y[5]);
   word3_muladd(&w1, &w0, &w2, x[7], y[4]);
   word3_muladd(&w1, &w0, &w2, x[8], y[3]);
   word3_muladd(&w1, &w0, &w2, x[9], y[2]);
   word3_muladd(&w1, &w0, &w2, x[10], y[1]);
   word3_muladd(&w1, &w0, &w2, x[11], y[0]);
   z[11] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[12]);
   word3_muladd(&w2, &w1, &w0, x[1], y[11]);
   word3_muladd(&w2, &w1, &w0, x[2], y[10]);
   word3_muladd(&w2, &w1, &w0, x[3], y[9]);
   word3_muladd(&w2, &w1, &w0, x[4], y[8]);
   word3_muladd(&w2, &w1, &w0, x[5], y[7]);
   word3_muladd(&w2, &w1, &w0, x[6], y[6]);
   word3_muladd(&w2, &w1, &w0, x[7], y[5]);
   word3_muladd(&w2, &w1, &w0, x[8], y[4]);
   word3_muladd(&w2, &w1, &w0, x[9], y[3]);
   word3_muladd(&w2, &w1, &w0, x[10], y[2]);
   word3_muladd(&w2, &w1, &w0, x[11], y[1]);
   word3_muladd(&w2, &w1, &w0, x[12], y[0]);
   z[12] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[13]);
   word3_muladd(&w0, &w2, &w1, x[1], y[12]);
   word3_muladd(&w0, &w2, &w1, x[2], y[11]);
   word3_muladd(&w0, &w2, &w1, x[3], y[10]);
   word3_muladd(&w0, &w2, &w1, x[4], y[9]);
   word3_muladd(&w0, &w2, &w1, x[5], y[8]);
   word3_muladd(&w0, &w2, &w1, x[6], y[7]);
   word3_muladd(&w0, &w2, &w1, x[7], y[6]);
   word3_muladd(&w0, &w2, &w1, x[8], y[5]);
   word3_muladd(&w0, &w2, &w1, x[9], y[4]);
   word3_muladd(&w0, &w2, &w1, x[10], y[3]);
   word3_muladd(&w0, &w2, &w1, x[11], y[2]);
   word3_muladd(&w0, &w2, &w1, x[12], y[1]);
   word3_muladd(&w0, &w2, &w1, x[13], y[0]);
   z[13] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[14]);
   word3_muladd(&w1, &w0, &w2, x[1], y[13]);
   word3_muladd(&w1, &w0, &w2, x[2], y[12]);
   word3_muladd(&w1, &w0, &w2, x[3], y[11]);
   word3_muladd(&w1, &w0, &w2, x[4], y[10]);
   word3_muladd(&w1, &w0, &w2, x[5], y[9]);
   word3_muladd(&w1, &w0, &w2, x[6], y[8]);
   word3_muladd(&w1, &w0, &w2, x[7], y[7]);
   word3_muladd(&w1, &w0, &w2, x[8], y[6]);
   word3_muladd(&w1, &w0, &w2, x[9], y[5]);
   word3_muladd(&w1, &w0, &w2, x[10], y[4]);
   word3_muladd(&w1, &w0, &w2, x[11], y[3]);
   word3_muladd(&w1, &w0, &w2, x[12], y[2]);
   word3_muladd(&w1, &w0, &w2, x[13], y[1]);
   word3_muladd(&w1, &w0, &w2, x[14], y[0]);
   z[14] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[15]);
   word3_muladd(&w2, &w1, &w0, x[1], y[14]);
   word3_muladd(&w2, &w1, &w0, x[2], y[13]);
   word3_muladd(&w2, &w1, &w0, x[3], y[12]);
   word3_muladd(&w2, &w1, &w0, x[4], y[11]);
   word3_muladd(&w2, &w1, &w0, x[5], y[10]);
   word3_muladd(&w2, &w1, &w0, x[6], y[9]);
   word3_muladd(&w2, &w1, &w0, x[7], y[8]);
   word3_muladd(&w2, &w1, &w0, x[8], y[7]);
   word3_muladd(&w2, &w1, &w0, x[9], y[6]);
   word3_muladd(&w2, &w1, &w0, x[10], y[5]);
   word3_muladd(&w2, &w1, &w0, x[11], y[4]);
   word3_muladd(&w2, &w1, &w0, x[12], y[3]);
   word3_muladd(&w2, &w1, &w0, x[13], y[2]);
   word3_muladd(&w2, &w1, &w0, x[14], y[1]);
   word3_muladd(&w2, &w1, &w0, x[15], y[0]);
   z[15] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[16]);
   word3_muladd(&w0, &w2, &w1, x[1], y[15]);
   word3_muladd(&w0, &w2, &w1, x[2], y[14]);
   word3_muladd(&w0, &w2, &w1, x[3], y[13]);
   word3_muladd(&w0, &w2, &w1, x[4], y[12]);
   word3_muladd(&w0, &w2, &w1, x[5], y[11]);
   word3_muladd(&w0, &w2, &w1, x[6], y[10]);
   word3_muladd(&w0, &w2, &w1, x[7], y[9]);
   word3_muladd(&w0, &w2, &w1, x[8], y[8]);
   word3_muladd(&w0, &w2, &w1, x[9], y[7]);
   word3_muladd(&w0, &w2, &w1, x[10], y[6]);
   word3_muladd(&w0, &w2, &w1, x[11], y[5]);
   word3_muladd(&w0, &w2, &w1, x[12], y[4]);
   word3_muladd(&w0, &w2, &w1, x[13], y[3]);
   word3_muladd(&w0, &w2, &w1, x[14], y[2]);
   word3_muladd(&w0, &w2, &w1, x[15], y[1]);
   word3_muladd(&w0, &w2, &w1, x[16], y[0]);
   z[16] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[17]);
   word3_muladd(&w1, &w0, &w2, x[1], y[16]);
   word3_muladd(&w1, &w0, &w2, x[2], y[15]);
   word3_muladd(&w1, &w0, &w2, x[3], y[14]);
   word3_muladd(&w1, &w0, &w2, x[4], y[13]);
   word3_muladd(&w1, &w0, &w2, x[5], y[12]);
   word3_muladd(&w1, &w0, &w2, x[6], y[11]);
   word3_muladd(&w1, &w0, &w2, x[7], y[10]);
   word3_muladd(&w1, &w0, &w2, x[8], y[9]);
   word3_muladd(&w1, &w0, &w2, x[9], y[8]);
   word3_muladd(&w1, &w0, &w2, x[10], y[7]);
   word3_muladd(&w1, &w0, &w2, x[11], y[6]);
   word3_muladd(&w1, &w0, &w2, x[12], y[5]);
   word3_muladd(&w1, &w0, &w2, x[13], y[4]);
   word3_muladd(&w1, &w0, &w2, x[14], y[3]);
   word3_muladd(&w1, &w0, &w2, x[15], y[2]);
   word3_muladd(&w1, &w0, &w2, x[16], y[1]);
   word3_muladd(&w1, &w0, &w2, x[17], y[0]);
   z[17] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[18]);
   word3_muladd(&w2, &w1, &w0, x[1], y[17]);
   word3_muladd(&w2, &w1, &w0, x[2], y[16]);
   word3_muladd(&w2, &w1, &w0, x[3], y[15]);
   word3_muladd(&w2, &w1, &w0, x[4], y[14]);
   word3_muladd(&w2, &w1, &w0, x[5], y[13]);
   word3_muladd(&w2, &w1, &w0, x[6], y[12]);
   word3_muladd(&w2, &w1, &w0, x[7], y[11]);
   word3_muladd(&w2, &w1, &w0, x[8], y[10]);
   word3_muladd(&w2, &w1, &w0, x[9], y[9]);
   word3_muladd(&w2, &w1, &w0, x[10], y[8]);
   word3_muladd(&w2, &w1, &w0, x[11], y[7]);
   word3_muladd(&w2, &w1, &w0, x[12], y[6]);
   word3_muladd(&w2, &w1, &w0, x[13], y[5]);
   word3_muladd(&w2, &w1, &w0, x[14], y[4]);
   word3_muladd(&w2, &w1, &w0, x[15], y[3]);
   word3_muladd(&w2, &w1, &w0, x[16], y[2]);
   word3_muladd(&w2, &w1, &w0, x[17], y[1]);
   word3_muladd(&w2, &w1, &w0, x[18], y[0]);
   z[18] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[19]);
   word3_muladd(&w0, &w2, &w1, x[1], y[18]);
   word3_muladd(&w0, &w2, &w1, x[2], y[17]);
   word3_muladd(&w0, &w2, &w1, x[3], y[16]);
   word3_muladd(&w0, &w2, &w1, x[4], y[15]);
   word3_muladd(&w0, &w2, &w1, x[5], y[14]);
   word3_muladd(&w0, &w2, &w1, x[6], y[13]);
   word3_muladd(&w0, &w2, &w1, x[7], y[12]);
   word3_muladd(&w0, &w2, &w1, x[8], y[11]);
   word3_muladd(&w0, &w2, &w1, x[9], y[10]);
   word3_muladd(&w0, &w2, &w1, x[10], y[9]);
   word3_muladd(&w0, &w2, &w1, x[11], y[8]);
   word3_muladd(&w0, &w2, &w1, x[12], y[7]);
   word3_muladd(&w0, &w2, &w1, x[13], y[6]);
   word3_muladd(&w0, &w2, &w1, x[14], y[5]);
   word3_muladd(&w0, &w2, &w1, x[15], y[4]);
   word3_muladd(&w0, &w2, &w1, x[16], y[3]);
   word3_muladd(&w0, &w2, &w1, x[17], y[2]);
   word3_muladd(&w0, &w2, &w1, x[18], y[1]);
   word3_muladd(&w0, &w2, &w1, x[19], y[0]);
   z[19] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[20]);
   word3_muladd(&w1, &w0, &w2, x[1], y[19]);
   word3_muladd(&w1, &w0, &w2, x[2], y[18]);
   word3_muladd(&w1, &w0, &w2, x[3], y[17]);
   word3_muladd(&w1, &w0, &w2, x[4], y[16]);
   word3_muladd(&w1, &w0, &w2, x[5], y[15]);
   word3_muladd(&w1, &w0, &w2, x[6], y[14]);
   word3_muladd(&w1, &w0, &w2, x[7], y[13]);
   word3_muladd(&w1, &w0, &w2, x[8], y[12]);
   word3_muladd(&w1, &w0, &w2, x[9], y[11]);
   word3_muladd(&w1, &w0, &w2, x[10], y[10]);
   word3_muladd(&w1, &w0, &w2, x[11], y[9]);
   word3_muladd(&w1, &w0, &w2, x[12], y[8]);
   word3_muladd(&w1, &w0, &w2, x[13], y[7]);
   word3_muladd(&w1, &w0, &w2, x[14], y[6]);
   word3_muladd(&w1, &w0, &w2, x[15], y[5]);
   word3_muladd(&w1, &w0, &w2, x[16], y[4]);
   word3_muladd(&w1, &w0, &w2, x[17], y[3]);
   word3_muladd(&w1, &w0, &w2, x[18], y[2]);
   word3_muladd(&w1, &w0, &w2, x[19], y[1]);
   word3_muladd(&w1, &w0, &w2, x[20], y[0]);
   z[20] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[0], y[21]);
   word3_muladd(&w2, &w1, &w0, x[1], y[20]);
   word3_muladd(&w2, &w1, &w0, x[2], y[19]);
   word3_muladd(&w2, &w1, &w0, x[3], y[18]);
   word3_muladd(&w2, &w1, &w0, x[4], y[17]);
   word3_muladd(&w2, &w1, &w0, x[5], y[16]);
   word3_muladd(&w2, &w1, &w0, x[6], y[15]);
   word3_muladd(&w2, &w1, &w0, x[7], y[14]);
   word3_muladd(&w2, &w1, &w0, x[8], y[13]);
   word3_muladd(&w2, &w1, &w0, x[9], y[12]);
   word3_muladd(&w2, &w1, &w0, x[10], y[11]);
   word3_muladd(&w2, &w1, &w0, x[11], y[10]);
   word3_muladd(&w2, &w1, &w0, x[12], y[9]);
   word3_muladd(&w2, &w1, &w0, x[13], y[8]);
   word3_muladd(&w2, &w1, &w0, x[14], y[7]);
   word3_muladd(&w2, &w1, &w0, x[15], y[6]);
   word3_muladd(&w2, &w1, &w0, x[16], y[5]);
   word3_muladd(&w2, &w1, &w0, x[17], y[4]);
   word3_muladd(&w2, &w1, &w0, x[18], y[3]);
   word3_muladd(&w2, &w1, &w0, x[19], y[2]);
   word3_muladd(&w2, &w1, &w0, x[20], y[1]);
   word3_muladd(&w2, &w1, &w0, x[21], y[0]);
   z[21] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[0], y[22]);
   word3_muladd(&w0, &w2, &w1, x[1], y[21]);
   word3_muladd(&w0, &w2, &w1, x[2], y[20]);
   word3_muladd(&w0, &w2, &w1, x[3], y[19]);
   word3_muladd(&w0, &w2, &w1, x[4], y[18]);
   word3_muladd(&w0, &w2, &w1, x[5], y[17]);
   word3_muladd(&w0, &w2, &w1, x[6], y[16]);
   word3_muladd(&w0, &w2, &w1, x[7], y[15]);
   word3_muladd(&w0, &w2, &w1, x[8], y[14]);
   word3_muladd(&w0, &w2, &w1, x[9], y[13]);
   word3_muladd(&w0, &w2, &w1, x[10], y[12]);
   word3_muladd(&w0, &w2, &w1, x[11], y[11]);
   word3_muladd(&w0, &w2, &w1, x[12], y[10]);
   word3_muladd(&w0, &w2, &w1, x[13], y[9]);
   word3_muladd(&w0, &w2, &w1, x[14], y[8]);
   word3_muladd(&w0, &w2, &w1, x[15], y[7]);
   word3_muladd(&w0, &w2, &w1, x[16], y[6]);
   word3_muladd(&w0, &w2, &w1, x[17], y[5]);
   word3_muladd(&w0, &w2, &w1, x[18], y[4]);
   word3_muladd(&w0, &w2, &w1, x[19], y[3]);
   word3_muladd(&w0, &w2, &w1, x[20], y[2]);
   word3_muladd(&w0, &w2, &w1, x[21], y[1]);
   word3_muladd(&w0, &w2, &w1, x[22], y[0]);
   z[22] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[0], y[23]);
   word3_muladd(&w1, &w0, &w2, x[1], y[22]);
   word3_muladd(&w1, &w0, &w2, x[2], y[21]);
   word3_muladd(&w1, &w0, &w2, x[3], y[20]);
   word3_muladd(&w1, &w0, &w2, x[4], y[19]);
   word3_muladd(&w1, &w0, &w2, x[5], y[18]);
   word3_muladd(&w1, &w0, &w2, x[6], y[17]);
   word3_muladd(&w1, &w0, &w2, x[7], y[16]);
   word3_muladd(&w1, &w0, &w2, x[8], y[15]);
   word3_muladd(&w1, &w0, &w2, x[9], y[14]);
   word3_muladd(&w1, &w0, &w2, x[10], y[13]);
   word3_muladd(&w1, &w0, &w2, x[11], y[12]);
   word3_muladd(&w1, &w0, &w2, x[12], y[11]);
   word3_muladd(&w1, &w0, &w2, x[13], y[10]);
   word3_muladd(&w1, &w0, &w2, x[14], y[9]);
   word3_muladd(&w1, &w0, &w2, x[15], y[8]);
   word3_muladd(&w1, &w0, &w2, x[16], y[7]);
   word3_muladd(&w1, &w0, &w2, x[17], y[6]);
   word3_muladd(&w1, &w0, &w2, x[18], y[5]);
   word3_muladd(&w1, &w0, &w2, x[19], y[4]);
   word3_muladd(&w1, &w0, &w2, x[20], y[3]);
   word3_muladd(&w1, &w0, &w2, x[21], y[2]);
   word3_muladd(&w1, &w0, &w2, x[22], y[1]);
   word3_muladd(&w1, &w0, &w2, x[23], y[0]);
   z[23] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[1], y[23]);
   word3_muladd(&w2, &w1, &w0, x[2], y[22]);
   word3_muladd(&w2, &w1, &w0, x[3], y[21]);
   word3_muladd(&w2, &w1, &w0, x[4], y[20]);
   word3_muladd(&w2, &w1, &w0, x[5], y[19]);
   word3_muladd(&w2, &w1, &w0, x[6], y[18]);
   word3_muladd(&w2, &w1, &w0, x[7], y[17]);
   word3_muladd(&w2, &w1, &w0, x[8], y[16]);
   word3_muladd(&w2, &w1, &w0, x[9], y[15]);
   word3_muladd(&w2, &w1, &w0, x[10], y[14]);
   word3_muladd(&w2, &w1, &w0, x[11], y[13]);
   word3_muladd(&w2, &w1, &w0, x[12], y[12]);
   word3_muladd(&w2, &w1, &w0, x[13], y[11]);
   word3_muladd(&w2, &w1, &w0, x[14], y[10]);
   word3_muladd(&w2, &w1, &w0, x[15], y[9]);
   word3_muladd(&w2, &w1, &w0, x[16], y[8]);
   word3_muladd(&w2, &w1, &w0, x[17], y[7]);
   word3_muladd(&w2, &w1, &w0, x[18], y[6]);
   word3_muladd(&w2, &w1, &w0, x[19], y[5]);
   word3_muladd(&w2, &w1, &w0, x[20], y[4]);
   word3_muladd(&w2, &w1, &w0, x[21], y[3]);
   word3_muladd(&w2, &w1, &w0, x[22], y[2]);
   word3_muladd(&w2, &w1, &w0, x[23], y[1]);
   z[24] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[2], y[23]);
   word3_muladd(&w0, &w2, &w1, x[3], y[22]);
   word3_muladd(&w0, &w2, &w1, x[4], y[21]);
   word3_muladd(&w0, &w2, &w1, x[5], y[20]);
   word3_muladd(&w0, &w2, &w1, x[6], y[19]);
   word3_muladd(&w0, &w2, &w1, x[7], y[18]);
   word3_muladd(&w0, &w2, &w1, x[8], y[17]);
   word3_muladd(&w0, &w2, &w1, x[9], y[16]);
   word3_muladd(&w0, &w2, &w1, x[10], y[15]);
   word3_muladd(&w0, &w2, &w1, x[11], y[14]);
   word3_muladd(&w0, &w2, &w1, x[12], y[13]);
   word3_muladd(&w0, &w2, &w1, x[13], y[12]);
   word3_muladd(&w0, &w2, &w1, x[14], y[11]);
   word3_muladd(&w0, &w2, &w1, x[15], y[10]);
   word3_muladd(&w0, &w2, &w1, x[16], y[9]);
   word3_muladd(&w0, &w2, &w1, x[17], y[8]);
   word3_muladd(&w0, &w2, &w1, x[18], y[7]);
   word3_muladd(&w0, &w2, &w1, x[19], y[6]);
   word3_muladd(&w0, &w2, &w1, x[20], y[5]);
   word3_muladd(&w0, &w2, &w1, x[21], y[4]);
   word3_muladd(&w0, &w2, &w1, x[22], y[3]);
   word3_muladd(&w0, &w2, &w1, x[23], y[2]);
   z[25] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[3], y[23]);
   word3_muladd(&w1, &w0, &w2, x[4], y[22]);
   word3_muladd(&w1, &w0, &w2, x[5], y[21]);
   word3_muladd(&w1, &w0, &w2, x[6], y[20]);
   word3_muladd(&w1, &w0, &w2, x[7], y[19]);
   word3_muladd(&w1, &w0, &w2, x[8], y[18]);
   word3_muladd(&w1, &w0, &w2, x[9], y[17]);
   word3_muladd(&w1, &w0, &w2, x[10], y[16]);
   word3_muladd(&w1, &w0, &w2, x[11], y[15]);
   word3_muladd(&w1, &w0, &w2, x[12], y[14]);
   word3_muladd(&w1, &w0, &w2, x[13], y[13]);
   word3_muladd(&w1, &w0, &w2, x[14], y[12]);
   word3_muladd(&w1, &w0, &w2, x[15], y[11]);
   word3_muladd(&w1, &w0, &w2, x[16], y[10]);
   word3_muladd(&w1, &w0, &w2, x[17], y[9]);
   word3_muladd(&w1, &w0, &w2, x[18], y[8]);
   word3_muladd(&w1, &w0, &w2, x[19], y[7]);
   word3_muladd(&w1, &w0, &w2, x[20], y[6]);
   word3_muladd(&w1, &w0, &w2, x[21], y[5]);
   word3_muladd(&w1, &w0, &w2, x[22], y[4]);
   word3_muladd(&w1, &w0, &w2, x[23], y[3]);
   z[26] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[4], y[23]);
   word3_muladd(&w2, &w1, &w0, x[5], y[22]);
   word3_muladd(&w2, &w1, &w0, x[6], y[21]);
   word3_muladd(&w2, &w1, &w0, x[7], y[20]);
   word3_muladd(&w2, &w1, &w0, x[8], y[19]);
   word3_muladd(&w2, &w1, &w0, x[9], y[18]);
   word3_muladd(&w2, &w1, &w0, x[10], y[17]);
   word3_muladd(&w2, &w1, &w0, x[11], y[16]);
   word3_muladd(&w2, &w1, &w0, x[12], y[15]);
   word3_muladd(&w2, &w1, &w0, x[13], y[14]);
   word3_muladd(&w2, &w1, &w0, x[14], y[13]);
   word3_muladd(&w2, &w1, &w0, x[15], y[12]);
   word3_muladd(&w2, &w1, &w0, x[16], y[11]);
   word3_muladd(&w2, &w1, &w0, x[17], y[10]);
   word3_muladd(&w2, &w1, &w0, x[18], y[9]);
   word3_muladd(&w2, &w1, &w0, x[19], y[8]);
   word3_muladd(&w2, &w1, &w0, x[20], y[7]);
   word3_muladd(&w2, &w1, &w0, x[21], y[6]);
   word3_muladd(&w2, &w1, &w0, x[22], y[5]);
   word3_muladd(&w2, &w1, &w0, x[23], y[4]);
   z[27] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[5], y[23]);
   word3_muladd(&w0, &w2, &w1, x[6], y[22]);
   word3_muladd(&w0, &w2, &w1, x[7], y[21]);
   word3_muladd(&w0, &w2, &w1, x[8], y[20]);
   word3_muladd(&w0, &w2, &w1, x[9], y[19]);
   word3_muladd(&w0, &w2, &w1, x[10], y[18]);
   word3_muladd(&w0, &w2, &w1, x[11], y[17]);
   word3_muladd(&w0, &w2, &w1, x[12], y[16]);
   word3_muladd(&w0, &w2, &w1, x[13], y[15]);
   word3_muladd(&w0, &w2, &w1, x[14], y[14]);
   word3_muladd(&w0, &w2, &w1, x[15], y[13]);
   word3_muladd(&w0, &w2, &w1, x[16], y[12]);
   word3_muladd(&w0, &w2, &w1, x[17], y[11]);
   word3_muladd(&w0, &w2, &w1, x[18], y[10]);
   word3_muladd(&w0, &w2, &w1, x[19], y[9]);
   word3_muladd(&w0, &w2, &w1, x[20], y[8]);
   word3_muladd(&w0, &w2, &w1, x[21], y[7]);
   word3_muladd(&w0, &w2, &w1, x[22], y[6]);
   word3_muladd(&w0, &w2, &w1, x[23], y[5]);
   z[28] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[6], y[23]);
   word3_muladd(&w1, &w0, &w2, x[7], y[22]);
   word3_muladd(&w1, &w0, &w2, x[8], y[21]);
   word3_muladd(&w1, &w0, &w2, x[9], y[20]);
   word3_muladd(&w1, &w0, &w2, x[10], y[19]);
   word3_muladd(&w1, &w0, &w2, x[11], y[18]);
   word3_muladd(&w1, &w0, &w2, x[12], y[17]);
   word3_muladd(&w1, &w0, &w2, x[13], y[16]);
   word3_muladd(&w1, &w0, &w2, x[14], y[15]);
   word3_muladd(&w1, &w0, &w2, x[15], y[14]);
   word3_muladd(&w1, &w0, &w2, x[16], y[13]);
   word3_muladd(&w1, &w0, &w2, x[17], y[12]);
   word3_muladd(&w1, &w0, &w2, x[18], y[11]);
   word3_muladd(&w1, &w0, &w2, x[19], y[10]);
   word3_muladd(&w1, &w0, &w2, x[20], y[9]);
   word3_muladd(&w1, &w0, &w2, x[21], y[8]);
   word3_muladd(&w1, &w0, &w2, x[22], y[7]);
   word3_muladd(&w1, &w0, &w2, x[23], y[6]);
   z[29] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[7], y[23]);
   word3_muladd(&w2, &w1, &w0, x[8], y[22]);
   word3_muladd(&w2, &w1, &w0, x[9], y[21]);
   word3_muladd(&w2, &w1, &w0, x[10], y[20]);
   word3_muladd(&w2, &w1, &w0, x[11], y[19]);
   word3_muladd(&w2, &w1, &w0, x[12], y[18]);
   word3_muladd(&w2, &w1, &w0, x[13], y[17]);
   word3_muladd(&w2, &w1, &w0, x[14], y[16]);
   word3_muladd(&w2, &w1, &w0, x[15], y[15]);
   word3_muladd(&w2, &w1, &w0, x[16], y[14]);
   word3_muladd(&w2, &w1, &w0, x[17], y[13]);
   word3_muladd(&w2, &w1, &w0, x[18], y[12]);
   word3_muladd(&w2, &w1, &w0, x[19], y[11]);
   word3_muladd(&w2, &w1, &w0, x[20], y[10]);
   word3_muladd(&w2, &w1, &w0, x[21], y[9]);
   word3_muladd(&w2, &w1, &w0, x[22], y[8]);
   word3_muladd(&w2, &w1, &w0, x[23], y[7]);
   z[30] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[8], y[23]);
   word3_muladd(&w0, &w2, &w1, x[9], y[22]);
   word3_muladd(&w0, &w2, &w1, x[10], y[21]);
   word3_muladd(&w0, &w2, &w1, x[11], y[20]);
   word3_muladd(&w0, &w2, &w1, x[12], y[19]);
   word3_muladd(&w0, &w2, &w1, x[13], y[18]);
   word3_muladd(&w0, &w2, &w1, x[14], y[17]);
   word3_muladd(&w0, &w2, &w1, x[15], y[16]);
   word3_muladd(&w0, &w2, &w1, x[16], y[15]);
   word3_muladd(&w0, &w2, &w1, x[17], y[14]);
   word3_muladd(&w0, &w2, &w1, x[18], y[13]);
   word3_muladd(&w0, &w2, &w1, x[19], y[12]);
   word3_muladd(&w0, &w2, &w1, x[20], y[11]);
   word3_muladd(&w0, &w2, &w1, x[21], y[10]);
   word3_muladd(&w0, &w2, &w1, x[22], y[9]);
   word3_muladd(&w0, &w2, &w1, x[23], y[8]);
   z[31] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[9], y[23]);
   word3_muladd(&w1, &w0, &w2, x[10], y[22]);
   word3_muladd(&w1, &w0, &w2, x[11], y[21]);
   word3_muladd(&w1, &w0, &w2, x[12], y[20]);
   word3_muladd(&w1, &w0, &w2, x[13], y[19]);
   word3_muladd(&w1, &w0, &w2, x[14], y[18]);
   word3_muladd(&w1, &w0, &w2, x[15], y[17]);
   word3_muladd(&w1, &w0, &w2, x[16], y[16]);
   word3_muladd(&w1, &w0, &w2, x[17], y[15]);
   word3_muladd(&w1, &w0, &w2, x[18], y[14]);
   word3_muladd(&w1, &w0, &w2, x[19], y[13]);
   word3_muladd(&w1, &w0, &w2, x[20], y[12]);
   word3_muladd(&w1, &w0, &w2, x[21], y[11]);
   word3_muladd(&w1, &w0, &w2, x[22], y[10]);
   word3_muladd(&w1, &w0, &w2, x[23], y[9]);
   z[32] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[10], y[23]);
   word3_muladd(&w2, &w1, &w0, x[11], y[22]);
   word3_muladd(&w2, &w1, &w0, x[12], y[21]);
   word3_muladd(&w2, &w1, &w0, x[13], y[20]);
   word3_muladd(&w2, &w1, &w0, x[14], y[19]);
   word3_muladd(&w2, &w1, &w0, x[15], y[18]);
   word3_muladd(&w2, &w1, &w0, x[16], y[17]);
   word3_muladd(&w2, &w1, &w0, x[17], y[16]);
   word3_muladd(&w2, &w1, &w0, x[18], y[15]);
   word3_muladd(&w2, &w1, &w0, x[19], y[14]);
   word3_muladd(&w2, &w1, &w0, x[20], y[13]);
   word3_muladd(&w2, &w1, &w0, x[21], y[12]);
   word3_muladd(&w2, &w1, &w0, x[22], y[11]);
   word3_muladd(&w2, &w1, &w0, x[23], y[10]);
   z[33] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[11], y[23]);
   word3_muladd(&w0, &w2, &w1, x[12], y[22]);
   word3_muladd(&w0, &w2, &w1, x[13], y[21]);
   word3_muladd(&w0, &w2, &w1, x[14], y[20]);
   word3_muladd(&w0, &w2, &w1, x[15], y[19]);
   word3_muladd(&w0, &w2, &w1, x[16], y[18]);
   word3_muladd(&w0, &w2, &w1, x[17], y[17]);
   word3_muladd(&w0, &w2, &w1, x[18], y[16]);
   word3_muladd(&w0, &w2, &w1, x[19], y[15]);
   word3_muladd(&w0, &w2, &w1, x[20], y[14]);
   word3_muladd(&w0, &w2, &w1, x[21], y[13]);
   word3_muladd(&w0, &w2, &w1, x[22], y[12]);
   word3_muladd(&w0, &w2, &w1, x[23], y[11]);
   z[34] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[12], y[23]);
   word3_muladd(&w1, &w0, &w2, x[13], y[22]);
   word3_muladd(&w1, &w0, &w2, x[14], y[21]);
   word3_muladd(&w1, &w0, &w2, x[15], y[20]);
   word3_muladd(&w1, &w0, &w2, x[16], y[19]);
   word3_muladd(&w1, &w0, &w2, x[17], y[18]);
   word3_muladd(&w1, &w0, &w2, x[18], y[17]);
   word3_muladd(&w1, &w0, &w2, x[19], y[16]);
   word3_muladd(&w1, &w0, &w2, x[20], y[15]);
   word3_muladd(&w1, &w0, &w2, x[21], y[14]);
   word3_muladd(&w1, &w0, &w2, x[22], y[13]);
   word3_muladd(&w1, &w0, &w2, x[23], y[12]);
   z[35] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[13], y[23]);
   word3_muladd(&w2, &w1, &w0, x[14], y[22]);
   word3_muladd(&w2, &w1, &w0, x[15], y[21]);
   word3_muladd(&w2, &w1, &w0, x[16], y[20]);
   word3_muladd(&w2, &w1, &w0, x[17], y[19]);
   word3_muladd(&w2, &w1, &w0, x[18], y[18]);
   word3_muladd(&w2, &w1, &w0, x[19], y[17]);
   word3_muladd(&w2, &w1, &w0, x[20], y[16]);
   word3_muladd(&w2, &w1, &w0, x[21], y[15]);
   word3_muladd(&w2, &w1, &w0, x[22], y[14]);
   word3_muladd(&w2, &w1, &w0, x[23], y[13]);
   z[36] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[14], y[23]);
   word3_muladd(&w0, &w2, &w1, x[15], y[22]);
   word3_muladd(&w0, &w2, &w1, x[16], y[21]);
   word3_muladd(&w0, &w2, &w1, x[17], y[20]);
   word3_muladd(&w0, &w2, &w1, x[18], y[19]);
   word3_muladd(&w0, &w2, &w1, x[19], y[18]);
   word3_muladd(&w0, &w2, &w1, x[20], y[17]);
   word3_muladd(&w0, &w2, &w1, x[21], y[16]);
   word3_muladd(&w0, &w2, &w1, x[22], y[15]);
   word3_muladd(&w0, &w2, &w1, x[23], y[14]);
   z[37] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[15], y[23]);
   word3_muladd(&w1, &w0, &w2, x[16], y[22]);
   word3_muladd(&w1, &w0, &w2, x[17], y[21]);
   word3_muladd(&w1, &w0, &w2, x[18], y[20]);
   word3_muladd(&w1, &w0, &w2, x[19], y[19]);
   word3_muladd(&w1, &w0, &w2, x[20], y[18]);
   word3_muladd(&w1, &w0, &w2, x[21], y[17]);
   word3_muladd(&w1, &w0, &w2, x[22], y[16]);
   word3_muladd(&w1, &w0, &w2, x[23], y[15]);
   z[38] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[16], y[23]);
   word3_muladd(&w2, &w1, &w0, x[17], y[22]);
   word3_muladd(&w2, &w1, &w0, x[18], y[21]);
   word3_muladd(&w2, &w1, &w0, x[19], y[20]);
   word3_muladd(&w2, &w1, &w0, x[20], y[19]);
   word3_muladd(&w2, &w1, &w0, x[21], y[18]);
   word3_muladd(&w2, &w1, &w0, x[22], y[17]);
   word3_muladd(&w2, &w1, &w0, x[23], y[16]);
   z[39] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[17], y[23]);
   word3_muladd(&w0, &w2, &w1, x[18], y[22]);
   word3_muladd(&w0, &w2, &w1, x[19], y[21]);
   word3_muladd(&w0, &w2, &w1, x[20], y[20]);
   word3_muladd(&w0, &w2, &w1, x[21], y[19]);
   word3_muladd(&w0, &w2, &w1, x[22], y[18]);
   word3_muladd(&w0, &w2, &w1, x[23], y[17]);
   z[40] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[18], y[23]);
   word3_muladd(&w1, &w0, &w2, x[19], y[22]);
   word3_muladd(&w1, &w0, &w2, x[20], y[21]);
   word3_muladd(&w1, &w0, &w2, x[21], y[20]);
   word3_muladd(&w1, &w0, &w2, x[22], y[19]);
   word3_muladd(&w1, &w0, &w2, x[23], y[18]);
   z[41] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[19], y[23]);
   word3_muladd(&w2, &w1, &w0, x[20], y[22]);
   word3_muladd(&w2, &w1, &w0, x[21], y[21]);
   word3_muladd(&w2, &w1, &w0, x[22], y[20]);
   word3_muladd(&w2, &w1, &w0, x[23], y[19]);
   z[42] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[20], y[23]);
   word3_muladd(&w0, &w2, &w1, x[21], y[22]);
   word3_muladd(&w0, &w2, &w1, x[22], y[21]);
   word3_muladd(&w0, &w2, &w1, x[23], y[20]);
   z[43] = w1;
   w1 = 0;

   word3_muladd(&w1, &w0, &w2, x[21], y[23]);
   word3_muladd(&w1, &w0, &w2, x[22], y[22]);
   word3_muladd(&w1, &w0, &w2, x[23], y[21]);
   z[44] = w2;
   w2 = 0;

   word3_muladd(&w2, &w1, &w0, x[22], y[23]);
   word3_muladd(&w2, &w1, &w0, x[23], y[22]);
   z[45] = w0;
   w0 = 0;

   word3_muladd(&w0, &w2, &w1, x[23], y[23]);
   z[46] = w1;
   z[47] = w2;
}

}  // namespace Botan
